/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.descriptive;

import java.util.Objects;
import org.apache.commons.numbers.arrays.Selection;
import org.apache.commons.statistics.descriptive.Interpolation;
import org.apache.commons.statistics.descriptive.NaNPolicy;
import org.apache.commons.statistics.descriptive.NaNTransformer;
import org.apache.commons.statistics.descriptive.NaNTransformers;

public final class Median {
    private static final Median DEFAULT = new Median(false, NaNPolicy.INCLUDE);
    private final boolean copy;
    private final NaNPolicy nanPolicy;
    private final NaNTransformer nanTransformer;

    private Median(boolean copy, NaNPolicy nanPolicy) {
        this.copy = copy;
        this.nanPolicy = nanPolicy;
        this.nanTransformer = NaNTransformers.createNaNTransformer(nanPolicy, copy);
    }

    public static Median withDefaults() {
        return DEFAULT;
    }

    public Median withCopy(boolean v) {
        return new Median(v, this.nanPolicy);
    }

    public Median with(NaNPolicy v) {
        return new Median(this.copy, Objects.requireNonNull(v));
    }

    public double evaluate(double[] values) {
        int[] bounds = new int[1];
        double[] x = this.nanTransformer.apply(values, bounds);
        int n = bounds[0];
        if (n <= 2) {
            switch (n) {
                case 2: {
                    if (Double.compare(x[1], x[0]) < 0) {
                        double t = x[0];
                        x[0] = x[1];
                        x[1] = t;
                    }
                    return Interpolation.mean(x[0], x[1]);
                }
                case 1: {
                    return x[0];
                }
            }
            return Double.NaN;
        }
        int m = n >>> 1;
        if ((n & 1) == 1) {
            Selection.select((double[])x, (int)0, (int)n, (int)m);
            return x[m];
        }
        Selection.select((double[])x, (int)0, (int)n, (int[])new int[]{m - 1, m});
        return Interpolation.mean(x[m - 1], x[m]);
    }

    public double evaluate(int[] values) {
        int[] x = this.copy ? (int[])values.clone() : values;
        int n = values.length;
        if (n <= 2) {
            switch (n) {
                case 2: {
                    if (x[1] < x[0]) {
                        int t = x[0];
                        x[0] = x[1];
                        x[1] = t;
                    }
                    return Interpolation.mean(x[0], x[1]);
                }
                case 1: {
                    return x[0];
                }
            }
            return Double.NaN;
        }
        int m = n >>> 1;
        if ((n & 1) == 1) {
            Selection.select((int[])x, (int)0, (int)n, (int)m);
            return x[m];
        }
        Selection.select((int[])x, (int)0, (int)n, (int[])new int[]{m - 1, m});
        return Interpolation.mean(x[m - 1], x[m]);
    }
}

