/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.descriptive;

import java.math.BigInteger;
import org.apache.commons.statistics.descriptive.LongStatistic;
import org.apache.commons.statistics.descriptive.StatisticAccumulator;
import org.apache.commons.statistics.descriptive.Statistics;

public final class LongMin
implements LongStatistic,
StatisticAccumulator<LongMin> {
    private long minimum = Long.MAX_VALUE;

    private LongMin() {
    }

    public static LongMin create() {
        return new LongMin();
    }

    public static LongMin of(long ... values) {
        return Statistics.add(new LongMin(), values);
    }

    @Override
    public void accept(long value) {
        this.minimum = Math.min(this.minimum, value);
    }

    @Override
    public long getAsLong() {
        return this.minimum;
    }

    @Override
    public int getAsInt() {
        return Math.toIntExact(this.minimum);
    }

    @Override
    public double getAsDouble() {
        return this.minimum;
    }

    @Override
    public BigInteger getAsBigInteger() {
        return BigInteger.valueOf(this.minimum);
    }

    @Override
    public LongMin combine(LongMin other) {
        this.accept(other.getAsLong());
        return this;
    }
}

