/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.descriptive;

import org.apache.commons.statistics.descriptive.Int128;
import org.apache.commons.statistics.descriptive.IntMath;
import org.apache.commons.statistics.descriptive.IntStatistic;
import org.apache.commons.statistics.descriptive.StatisticAccumulator;

public final class IntMean
implements IntStatistic,
StatisticAccumulator<IntMean> {
    private static final long SMALL_N = 0x200000L;
    private final Int128 sum;
    private long n;

    private IntMean() {
        this(Int128.create(), 0);
    }

    private IntMean(Int128 sum, int n) {
        this.sum = sum;
        this.n = n;
    }

    public static IntMean create() {
        return new IntMean();
    }

    public static IntMean of(int ... values) {
        long s = 0L;
        for (int x : values) {
            s += (long)x;
        }
        return new IntMean(Int128.of(s), values.length);
    }

    @Override
    public void accept(int value) {
        this.sum.add(value);
        ++this.n;
    }

    @Override
    public double getAsDouble() {
        return IntMean.computeMean(this.sum, this.n);
    }

    static double computeMean(Int128 sum, long n) {
        if (n < 0x200000L) {
            return (double)sum.lo64() / (double)n;
        }
        return IntMath.divide(sum, n);
    }

    @Override
    public IntMean combine(IntMean other) {
        this.sum.add(other.sum);
        this.n += other.n;
        return this;
    }
}

