/*
 * Decompiled with CFR 0.152.
 */
package dev.aisandbox.server.simulation.twisty;

import dev.aisandbox.server.engine.Agent;
import dev.aisandbox.server.engine.Simulation;
import dev.aisandbox.server.engine.SimulationBuilder;
import dev.aisandbox.server.engine.SimulationParameter;
import dev.aisandbox.server.engine.Theme;
import dev.aisandbox.server.simulation.twisty.PuzzleType;
import dev.aisandbox.server.simulation.twisty.TwistySimulation;
import java.util.List;
import java.util.Random;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TwistyBuilder
implements SimulationBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TwistyBuilder.class);
    private PuzzleType puzzleType = PuzzleType.CUBE3;
    private Boolean startSolved = false;

    @Override
    public String getSimulationName() {
        return "Twisty";
    }

    @Override
    public String getDescription() {
        return "Solve various twisting puzzles.";
    }

    @Override
    public List<SimulationParameter> getParameters() {
        return List.of(new SimulationParameter("puzzleType", "The design of the puzzle", PuzzleType.class), new SimulationParameter("startSolved", "Start with a solved puzzle", Boolean.class));
    }

    @Override
    public int getMinAgentCount() {
        return 1;
    }

    @Override
    public int getMaxAgentCount() {
        return 1;
    }

    @Override
    public String[] getAgentNames(int agentCount) {
        return new String[]{"Agent 1"};
    }

    @Override
    public Simulation build(List<Agent> agents, Theme theme, Random random) {
        try {
            return new TwistySimulation(agents.getFirst(), this.puzzleType.getTwistyPuzzle(), this.startSolved, theme, random);
        }
        catch (Exception e) {
            log.error("Error while building Twisty Runtime.", (Throwable)e);
            return null;
        }
    }

    @Generated
    public void setPuzzleType(PuzzleType puzzleType) {
        this.puzzleType = puzzleType;
    }

    @Generated
    public void setStartSolved(Boolean startSolved) {
        this.startSolved = startSolved;
    }

    @Generated
    public PuzzleType getPuzzleType() {
        return this.puzzleType;
    }

    @Generated
    public Boolean getStartSolved() {
        return this.startSolved;
    }
}

