/*
 * Decompiled with CFR 0.152.
 */
package dev.aisandbox.server.simulation.mine;

import dev.aisandbox.server.engine.Agent;
import dev.aisandbox.server.engine.Simulation;
import dev.aisandbox.server.engine.Theme;
import dev.aisandbox.server.engine.exception.SimulationException;
import dev.aisandbox.server.engine.output.OutputConstants;
import dev.aisandbox.server.engine.output.OutputRenderer;
import dev.aisandbox.server.engine.output.SpriteLoader;
import dev.aisandbox.server.engine.widget.GraphicsUtils;
import dev.aisandbox.server.engine.widget.RollingPieChartWidget;
import dev.aisandbox.server.engine.widget.TextWidget;
import dev.aisandbox.server.engine.widget.TitleWidget;
import dev.aisandbox.server.simulation.mine.Board;
import dev.aisandbox.server.simulation.mine.Cell;
import dev.aisandbox.server.simulation.mine.GameState;
import dev.aisandbox.server.simulation.mine.MineSize;
import dev.aisandbox.server.simulation.mine.proto.FlagAction;
import dev.aisandbox.server.simulation.mine.proto.MineAction;
import dev.aisandbox.server.simulation.mine.proto.MineResult;
import dev.aisandbox.server.simulation.mine.proto.MineSignal;
import dev.aisandbox.server.simulation.mine.proto.MineState;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MineHunterRuntime
implements Simulation {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MineHunterRuntime.class);
    private static final int BAIZE_HEIGHT = 880;
    private static final int BAIZE_WIDTH = 1173;
    private static final int BOARD_START_X = 236;
    private static final int LOG_WIDTH = 597;
    private static final int BAIZE_SPACING = 16;
    private static final int BOARD_START_Y = 214;
    private static final int LOG_HEIGHT = 415;
    private final Agent agent;
    private final Random random;
    private final MineSize mineSize;
    private final Theme theme;
    private final String sessionID = UUID.randomUUID().toString();
    private final List<BufferedImage> sprites;
    private final RollingPieChartWidget pieChartWidget;
    private final TitleWidget titleWidget;
    private final TextWidget logWidget;
    private final long boardsWon = 0L;
    private final long boardsLost = 0L;
    private Board board = null;
    private int flagsLeft;
    private double scale = 1.0;
    private String episodeID;

    public MineHunterRuntime(Agent agent, MineSize mineSize, Theme theme, Random random) {
        this.agent = agent;
        this.random = random;
        this.mineSize = mineSize;
        this.theme = theme;
        this.sprites = SpriteLoader.loadSpritesFromResources("/images/mine/grid.png", 40, 40);
        this.titleWidget = TitleWidget.builder().title("Mine Hunter").theme(theme).build();
        this.logWidget = TextWidget.builder().width(597).height(415).font(OutputConstants.LOG_FONT).theme(theme).build();
        this.pieChartWidget = RollingPieChartWidget.builder().width(597).height(415).title("% success of the last 200 episodes.").theme(theme).build();
        this.getNewBoard();
    }

    private void getNewBoard() {
        log.debug("Initialising board");
        this.board = new Board(this.mineSize.getWidth(), this.mineSize.getHeight());
        this.board.placeMines(this.random, this.mineSize.getCount());
        this.flagsLeft = this.mineSize.getCount();
        this.board.countNeighbours();
        this.scale = 20.0 / (double)this.board.getHeight();
        log.debug("Scaling board to {}", (Object)this.scale);
        this.episodeID = UUID.randomUUID().toString();
    }

    @Override
    public void step(OutputRenderer output) throws SimulationException {
        this.agent.send(this.getState());
        MineAction action = this.agent.receive(MineAction.class);
        if (action.getAction().equals((Object)FlagAction.PLACE_FLAG)) {
            this.logWidget.addText(this.agent.getAgentName() + ": placing flag @ " + action.getX() + "," + action.getY());
            this.board.placeFlag(action.getX(), action.getY());
        } else {
            this.logWidget.addText(this.agent.getAgentName() + ": uncovering flag @ " + action.getX() + "," + action.getY());
            this.board.uncover(action.getX(), action.getY());
        }
        MineResult.Builder rBuilder = MineResult.newBuilder();
        rBuilder.setAction(action.getAction());
        rBuilder.setX(action.getX());
        rBuilder.setY(action.getY());
        rBuilder.setAction(action.getAction());
        rBuilder.setSignal(switch (this.board.getState()) {
            case GameState.LOST -> MineSignal.LOSE;
            case GameState.WON -> MineSignal.WIN;
            default -> MineSignal.CONTINUE;
        });
        this.agent.send(rBuilder.build());
        if (this.board.getState() == GameState.WON) {
            this.logWidget.addText(this.agent.getAgentName() + ": won");
            this.pieChartWidget.addValue("win", this.theme.getPrimary());
        } else if (this.board.getState() == GameState.LOST) {
            this.logWidget.addText(this.agent.getAgentName() + ": lost");
            this.pieChartWidget.addValue("loss", this.theme.getSecondary());
        }
        output.display();
        if (this.board.getState() != GameState.PLAYING) {
            this.getNewBoard();
        }
    }

    public MineState getState() {
        MineState.Builder builder = MineState.newBuilder();
        builder.setEpisodeID(this.episodeID);
        builder.setSessionID(this.sessionID);
        builder.setHeight(this.mineSize.getHeight());
        builder.setWidth(this.mineSize.getWidth());
        builder.setFlagsLeft(this.flagsLeft);
        builder.addAllRow(List.of(this.board.getBoardToString()));
        return builder.build();
    }

    @Override
    public void visualise(Graphics2D graphics2D) {
        GraphicsUtils.setupRenderingHints(graphics2D);
        graphics2D.setColor(this.theme.getBase());
        graphics2D.fillRect(0, 0, 1920, 1080);
        graphics2D.drawImage((Image)this.titleWidget.getImage(), 0, 50, null);
        graphics2D.drawImage((Image)this.theme.getLogoImage(), 1779, 21, null);
        graphics2D.drawImage((Image)this.logWidget.getImage(), 1273, 615, null);
        graphics2D.drawImage((Image)this.pieChartWidget.getImage(), 1273, 150, null);
        graphics2D.setColor(this.theme.getBackground());
        graphics2D.fillRect(50, 150, 1173, 880);
        graphics2D.setColor(this.theme.getBorder());
        graphics2D.drawRect(50, 150, 1173, 880);
        GraphicsUtils.drawCenteredText(graphics2D, 50, 166, 1173, 32, "Mines Remaining : " + this.board.getUnfoundMines(), OutputConstants.STATISTICS_FONT, this.theme.getText());
        graphics2D.translate(236, 214);
        graphics2D.scale(this.scale, this.scale);
        for (int x = 0; x < this.board.getWidth(); ++x) {
            for (int y = 0; y < this.board.getHeight(); ++y) {
                Cell c = this.board.getCell(x, y);
                graphics2D.drawImage((Image)this.sprites.get(c.getPlayerViewSprite()), x * 40, y * 40, null);
            }
        }
    }
}

