/*
 * Decompiled with CFR 0.152.
 */
package dev.aisandbox.server.simulation.maze;

import dev.aisandbox.server.simulation.maze.Cell;
import dev.aisandbox.server.simulation.maze.Direction;
import dev.aisandbox.server.simulation.maze.Maze;
import dev.aisandbox.server.simulation.maze.MazeSize;
import dev.aisandbox.server.simulation.maze.MazeType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MazeGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MazeGenerator.class);

    public static Maze generateMaze(MazeSize size, MazeType mazeType, Random rand) {
        Maze maze = new Maze(size.getWidth(), size.getHeight(), size.getZoomLevel());
        switch (mazeType) {
            case BINARYTREE: {
                MazeGenerator.applyBinaryTree(rand, maze);
                break;
            }
            case SIDEWINDER: {
                MazeGenerator.applySidewinder(rand, maze);
                break;
            }
            case BRAIDED: {
                MazeGenerator.applyRecursiveBacktracker(rand, maze);
                MazeGenerator.removeDeadEnds(rand, maze);
                break;
            }
            case RECURSIVEBACKTRACKER: {
                MazeGenerator.applyRecursiveBacktracker(rand, maze);
            }
        }
        MazeGenerator.findFurthestPoints(maze);
        return maze;
    }

    public static void applyBinaryTree(Random rand, Maze maze) {
        log.debug("Applying binary tree to maze");
        for (Cell c : maze.getCellList()) {
            ArrayList<Cell> targets = new ArrayList<Cell>();
            if (c.getNeighbours().get((Object)Direction.EAST) != null) {
                targets.add(c.getNeighbours().get((Object)Direction.EAST));
            }
            if (c.getNeighbours().get((Object)Direction.NORTH) != null) {
                targets.add(c.getNeighbours().get((Object)Direction.NORTH));
            }
            if (targets.isEmpty()) continue;
            c.addPath((Cell)targets.get(rand.nextInt(targets.size())));
        }
        log.info("finished binary tree");
    }

    public static void applySidewinder(Random rand, Maze maze) {
        log.debug("Applying sidewinder to maze");
        for (int x = 0; x < maze.getWidth() - 1; ++x) {
            maze.getCellArray()[x][0].addPath(Direction.EAST);
        }
        for (int y = 1; y < maze.getHeight(); ++y) {
            ArrayList<Cell> group = new ArrayList<Cell>();
            for (int x = 0; x < maze.getWidth(); ++x) {
                Cell c = maze.getCellArray()[x][y];
                if (!group.isEmpty()) {
                    c.addPath(Direction.WEST);
                }
                group.add(c);
                if (x != maze.getWidth() - 1 && !rand.nextBoolean()) continue;
                Cell c2 = (Cell)group.get(rand.nextInt(group.size()));
                c2.addPath(Direction.NORTH);
                group.clear();
            }
        }
        log.debug("Finished sidewinder");
    }

    public static void applyRecursiveBacktracker(Random rand, Maze maze) {
        log.debug("Applying recursive backtracker");
        ArrayList<Cell> stack = new ArrayList<Cell>();
        ArrayList<Cell> unvisited = new ArrayList<Cell>(maze.getCellList());
        stack.add((Cell)unvisited.remove(rand.nextInt(unvisited.size())));
        while (!stack.isEmpty()) {
            Cell current = (Cell)stack.get(stack.size() - 1);
            ArrayList<Cell> neighbours = new ArrayList<Cell>();
            for (Cell n : current.getNeighbours().values()) {
                if (!unvisited.contains(n)) continue;
                neighbours.add(n);
            }
            if (neighbours.isEmpty()) {
                stack.remove(current);
                continue;
            }
            Cell next = (Cell)neighbours.get(rand.nextInt(neighbours.size()));
            current.addPath(next);
            stack.add(next);
            unvisited.remove(next);
        }
        log.debug("Finished backtracker");
    }

    public static void removeDeadEnds(Random rand, Maze maze) {
        for (Cell current : maze.getCellList()) {
            if (current.getPaths().size() >= 2) continue;
            ArrayList<Cell> target = new ArrayList<Cell>();
            for (Direction d : current.getNeighbours().keySet()) {
                if (current.isPath(d)) continue;
                target.add(current.getNeighbours().get((Object)d));
            }
            if (target.isEmpty()) continue;
            current.addPath((Cell)target.get(rand.nextInt(target.size())));
        }
    }

    public static void findFurthestPoints(Maze maze) {
        MazeGenerator.applyDijkstra(maze);
        Cell start = MazeGenerator.getHighestVelueCell(maze);
        maze.setStartCell(start);
        MazeGenerator.applyDijkstra(maze, start);
        Cell finish = MazeGenerator.getHighestVelueCell(maze);
        maze.setEndCell(finish);
        MazeGenerator.normalise(maze);
    }

    public static void applyDijkstra(Maze maze) {
        log.info("Applying dijkstra - picking random start cell from maze with {} cells", (Object)maze.getCellList().size());
        Random rand = new Random(System.currentTimeMillis());
        MazeGenerator.applyDijkstra(maze, maze.getCellList().get(rand.nextInt(maze.getCellList().size())));
    }

    public static Cell getHighestVelueCell(Maze maze) {
        Cell result = null;
        float v = Float.MIN_VALUE;
        for (Cell c : maze.getCellList()) {
            if (!(c.getValue() > v)) continue;
            v = c.getValue();
            result = c;
        }
        return result;
    }

    public static void applyDijkstra(Maze maze, Cell start) {
        HashSet<Cell> unvisitedList = new HashSet<Cell>();
        ArrayList<Cell> currentList = new ArrayList<Cell>();
        ArrayList<Cell> nextList = new ArrayList<Cell>();
        unvisitedList.addAll(maze.getCellList());
        currentList.add(start);
        unvisitedList.remove(start);
        int step = 0;
        while (!currentList.isEmpty()) {
            for (Cell base : currentList) {
                base.setValue(step);
                for (Direction d : base.getPaths()) {
                    Cell c2 = base.getNeighbours().get((Object)d);
                    if (!unvisitedList.contains(c2)) continue;
                    nextList.add(c2);
                    unvisitedList.remove(c2);
                }
            }
            currentList = nextList;
            nextList = new ArrayList();
            ++step;
        }
    }

    public static void normalise(Maze maze) {
        float max = Float.MIN_VALUE;
        float min = Float.MAX_VALUE;
        for (Cell c : maze.getCellList()) {
            max = Math.max(c.getValue(), max);
            min = Math.min(c.getValue(), min);
        }
        for (Cell c : maze.getCellList()) {
            c.setValue((c.getValue() - min) / (max - min));
        }
    }

    @Generated
    private MazeGenerator() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

