/*
 * Decompiled with CFR 0.152.
 */
package dev.aisandbox.server.engine.widget;

import dev.aisandbox.server.engine.Theme;
import dev.aisandbox.server.engine.output.OutputConstants;
import dev.aisandbox.server.engine.widget.GraphicsUtils;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TitleWidget {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TitleWidget.class);
    private final String title;
    private final Theme theme;
    private final BufferedImage image;

    public TitleWidget(String title, Theme theme) {
        this.title = title;
        this.theme = theme;
        this.image = GraphicsUtils.createBlankImage(1920, 50, theme.getBase());
        Graphics2D g = this.image.createGraphics();
        GraphicsUtils.setupRenderingHints(g);
        g.setColor(theme.getBase());
        g.fillRect(0, 0, 1920, 50);
        g.setColor(theme.getText());
        g.setFont(OutputConstants.TITLE_FONT);
        FontMetrics fm = g.getFontMetrics();
        int stringWidth = fm.stringWidth(title);
        g.drawString(title, 960 - stringWidth / 2, 50 - fm.getDescent());
    }

    public static TitleWidgetBuilder builder() {
        return new TitleWidgetBuilder();
    }

    @Generated
    public BufferedImage getImage() {
        return this.image;
    }

    public static class TitleWidgetBuilder {
        private String title = "Title";
        private Theme theme = Theme.LIGHT;

        public TitleWidget build() {
            return new TitleWidget(this.title, this.theme);
        }

        @Generated
        public TitleWidgetBuilder title(String title) {
            this.title = title;
            return this;
        }

        @Generated
        public TitleWidgetBuilder theme(Theme theme) {
            this.theme = theme;
            return this;
        }
    }
}

