/*
 * Decompiled with CFR 0.152.
 */
package dev.aisandbox.server.engine.widget;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import lombok.Generated;

public final class GraphicsUtils {
    public static BufferedImage createClearImage(int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 2);
        return image;
    }

    public static BufferedImage createBlankImage(int width, int height, Color color) {
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g = image.createGraphics();
        g.setColor(color);
        g.fillRect(0, 0, width, height);
        return image;
    }

    public static void setupRenderingHints(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        g.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        g.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
    }

    public static void drawVerticalCenteredText(Graphics2D graphics, int x, int y, int width, int height, String title, Font font, Color colour) {
        AffineTransform origTransform = graphics.getTransform();
        graphics.translate(x, y + height);
        graphics.rotate(Math.toRadians(-90.0));
        GraphicsUtils.drawCenteredText(graphics, 0, 0, height, width, title, font, colour);
        graphics.setTransform(origTransform);
    }

    public static void drawCenteredText(Graphics2D graphics, int x, int y, int width, int height, String text, Font font, Color colour) {
        graphics.setFont(font);
        graphics.setColor(colour);
        FontMetrics metrics = graphics.getFontMetrics(font);
        int dx = (width - metrics.stringWidth(text)) / 2;
        graphics.drawString(text, x + dx, y + height);
    }

    @Generated
    private GraphicsUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

