/*
 * Decompiled with CFR 0.152.
 */
package dev.aisandbox.server.engine.output;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OutputConstants {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OutputConstants.class);
    public static final int HD_WIDTH = 1920;
    public static final int HD_HEIGHT = 1080;
    public static final int LOGO_WIDTH = 91;
    public static final int LOGO_HEIGHT = 108;
    @Deprecated
    public static final int MARGIN = 100;
    public static final int TITLE_HEIGHT = 50;
    public static final int HEADER_HEIGHT = 40;
    public static final int TOP_MARGIN = 50;
    public static final int BOTTOM_MARGIN = 50;
    public static final int LEFT_MARGIN = 50;
    public static final int RIGHT_MARGIN = 50;
    public static final int WIDGET_SPACING = 50;
    public static final int LOG_FONT_HEIGHT = 16;
    public static final int STATISTICS_HEIGHT = 32;
    public static final int WIDGET_TITLE_HEIGHT = 18;
    public static final Font TITLE_FONT;
    public static final Font HEADER_FONT;
    public static final Font LOG_FONT;
    public static final Font STATISTICS_FONT;
    public static final Font WIDGET_TITLE_FONT;
    private static final List<String> FONT_LIST;

    @Generated
    private OutputConstants() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        FONT_LIST = List.of("/fonts/Arimo-VariableFont_wght.ttf", "/fonts/Hack-Regular.ttf");
        GraphicsEnvironment GE = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            for (String path : FONT_LIST) {
                log.debug("Loading font from {}", (Object)path);
                Font font = Font.createFont(0, OutputConstants.class.getResourceAsStream(path));
                log.debug("Registering font {}", (Object)font.getFontName());
                GE.registerFont(font);
            }
        }
        catch (FontFormatException | IOException e) {
            log.error("Error loading fonts", (Throwable)e);
        }
        TITLE_FONT = new Font("Arimo Regular", 0, 50);
        HEADER_FONT = new Font("Arimo Regular", 0, 40);
        LOG_FONT = new Font("Hack Regular", 0, 16);
        STATISTICS_FONT = new Font("Arimo Regular", 0, 32);
        WIDGET_TITLE_FONT = new Font("Arimo Regular", 0, 18);
    }
}

