/*
 * Decompiled with CFR 0.152.
 */
package dev.aisandbox.launcher.options;

import dev.aisandbox.launcher.options.RuntimeOptions;
import dev.aisandbox.server.engine.SimulationBuilder;
import dev.aisandbox.server.engine.SimulationParameter;
import dev.aisandbox.server.simulation.SimulationEnumeration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.EnumUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RuntimeUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RuntimeUtils.class);

    public static RuntimeOptions parseCommandLine(String[] args) {
        RuntimeOptions options = null;
        try {
            DefaultParser parser = new DefaultParser();
            CommandLine cmd = parser.parse(RuntimeUtils.getOptions(), args);
            RuntimeOptions.RuntimeOptionsBuilder workBuilder = RuntimeOptions.builder();
            if (cmd.hasOption('h')) {
                workBuilder.help(true);
            }
            if (cmd.hasOption('s')) {
                workBuilder.simulation(cmd.getOptionValue("s"));
            }
            if (cmd.hasOption('i')) {
                workBuilder.outputImage(true);
            }
            workBuilder.outputDirectory(".");
            if (cmd.hasOption('d')) {
                workBuilder.outputDirectory(cmd.getOptionValue("d"));
            }
            if (cmd.hasOption('k')) {
                workBuilder.skip(Integer.parseInt(cmd.getOptionValue("k")));
            }
            if (cmd.hasOption('a')) {
                workBuilder.agents(Integer.parseInt(cmd.getOptionValue('a')));
            }
            if (cmd.hasOption('e')) {
                workBuilder.maxStepCount(Long.parseLong(cmd.getOptionValue('e')));
            } else {
                workBuilder.maxStepCount(-1L);
            }
            if (cmd.hasOption('n')) {
                workBuilder.openExternal(true);
            }
            if (cmd.hasOption('t')) {
                workBuilder.startPort(Integer.parseInt(cmd.getOptionValue('t')));
            } else {
                workBuilder.startPort(9000);
            }
            if (cmd.hasOption('p')) {
                Arrays.stream(cmd.getOptionValues('p')).forEach(workBuilder::parameter);
            }
            options = workBuilder.build();
        }
        catch (ParseException e) {
            System.err.println("Error parsing command line arguments: " + e.getMessage());
            System.exit(-1);
        }
        return options;
    }

    public static Options getOptions() {
        Options options = new Options();
        options.addOption("h", "help", false, "Print an overview");
        options.addOption("s", "simulation", true, "Simulation to run [" + Arrays.stream(SimulationEnumeration.values()).map(simulationEnumeration -> simulationEnumeration.getBuilder().getSimulationName()).collect(Collectors.joining(" | ")) + "]");
        options.addOption("i", "png", false, "Write output to PNG files");
        options.addOption("d", "dir", true, "Output directory");
        options.addOption("k", "skip", true, "Frames to skip when rendering");
        options.addOption("e", "end", true, "End simulation after n steps");
        options.addOption("a", "agents", true, "Number of agents (within the range for a simulation)");
        options.addOption("p", "parameter", true, "Simulation specific parameter in the format key:value");
        options.addOption("n", "network", false, "Allow connections from the network (default localhost only)");
        options.addOption("t", "port", true, "Starting port (default 9000)");
        return options;
    }

    @Deprecated
    public static Optional<String> getParameterEnumOptions(Object bean, String parameter) {
        try {
            String methodName = "get" + Character.toUpperCase(parameter.charAt(0)) + parameter.substring(1);
            Method getMethod = bean.getClass().getMethod(methodName, new Class[0]);
            Object returnValue = getMethod.invoke(bean, new Object[0]);
            if (returnValue.getClass().isEnum()) {
                return Optional.of(Arrays.stream(returnValue.getClass().getEnumConstants()).map(Object::toString).collect(Collectors.joining(",")));
            }
            return Optional.empty();
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return Optional.empty();
        }
    }

    public static String getParameterValue(SimulationBuilder simulationBuilder, SimulationParameter parameter) {
        try {
            String methodName = "get" + Character.toUpperCase(parameter.name().charAt(0)) + parameter.name().substring(1);
            Method getMethod = simulationBuilder.getClass().getMethod(methodName, new Class[0]);
            return getMethod.invoke((Object)simulationBuilder, new Object[0]).toString();
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.warn("Error getting method information for parameter '{}' on class {}", new Object[]{parameter, simulationBuilder.getClass().getName(), e});
            return null;
        }
    }

    public static void setParameterValue(SimulationBuilder simulationBuilder, String name, String value) {
        Optional<SimulationParameter> oParam = simulationBuilder.getParameters().stream().filter(param -> param.name().equalsIgnoreCase(name)).findFirst();
        if (oParam.isPresent()) {
            SimulationParameter param2 = oParam.get();
            RuntimeUtils.setParameterValue(simulationBuilder, param2, value);
        }
    }

    public static void setParameterValue(SimulationBuilder simulationBuilder, SimulationParameter parameter, String value) {
        try {
            String methodName = "set" + Character.toUpperCase(parameter.name().charAt(0)) + parameter.name().substring(1);
            Optional<Method> oMethod = Arrays.stream(simulationBuilder.getClass().getMethods()).filter(m -> m.getName().equals(methodName)).filter(method -> Modifier.isPublic(method.getModifiers())).filter(method -> method.getParameterCount() == 1).filter(method -> method.getParameterTypes()[0] == parameter.parameterType()).findFirst();
            if (oMethod.isEmpty()) {
                log.error("Method {} not found", (Object)methodName);
            } else {
                Method m2 = oMethod.get();
                if (parameter.parameterType().isEnum()) {
                    Class<?> enumClass = parameter.parameterType();
                    boolean isValid = EnumUtils.isValidEnumIgnoreCase(enumClass, (String)value);
                    if (isValid) {
                        Enum enumValue = EnumUtils.getEnumIgnoreCase(enumClass, (String)value);
                        m2.invoke((Object)simulationBuilder, enumValue);
                    } else {
                        log.warn("Can't set enum '{}' to '{}' as it isn't a valid option", (Object)parameter.parameterType().getName(), (Object)value);
                    }
                } else if (parameter.parameterType() == Boolean.class) {
                    m2.invoke((Object)simulationBuilder, Boolean.parseBoolean(value));
                } else if (parameter.parameterType() == Integer.class) {
                    m2.invoke((Object)simulationBuilder, Integer.parseInt(value));
                } else {
                    log.error("Dont know how to set parameter of type {} to '{}'", (Object)parameter.name(), (Object)value);
                }
            }
        }
        catch (Exception e) {
            log.warn("Error setting property {} to '{}'", (Object)parameter, (Object)value);
        }
    }

    @Generated
    private RuntimeUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

