/*
 * Decompiled with CFR 0.152.
 */
package dev.aisandbox.server.simulation.maze;

import dev.aisandbox.server.simulation.maze.Direction;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;

public class Cell {
    private final int positionX;
    private final int positionY;
    EnumMap<Direction, Cell> neighbours = new EnumMap(Direction.class);
    Set<Direction> paths = new HashSet<Direction>();
    private float value;

    public void link(Direction d, Cell c) {
        if (c != null) {
            this.neighbours.put(d, c);
        }
    }

    public void linkBi(Direction d, Cell c) {
        if (c != null) {
            this.neighbours.put(d, c);
            c.getNeighbours().put(d.opposite(), this);
        }
    }

    public Collection<Cell> getLinks() {
        return this.neighbours.values();
    }

    public boolean isLinked(Cell c) {
        return this.neighbours.containsValue(c);
    }

    public void disconnect() {
        Iterator<Map.Entry<Direction, Cell>> itr = this.neighbours.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<Direction, Cell> entry = itr.next();
            entry.getValue().getNeighbours().remove((Object)entry.getKey().opposite(), this);
            itr.remove();
        }
    }

    public boolean isPath(Direction direction) {
        return this.paths.contains((Object)direction);
    }

    public void addPath(Cell c) {
        for (Map.Entry<Direction, Cell> entry : this.neighbours.entrySet()) {
            if (entry.getValue() != c) continue;
            this.addPath(entry.getKey());
        }
    }

    public void addPath(Direction direction) {
        this.paths.add(direction);
        this.getNeighbours().get((Object)direction).getPaths().add(direction.opposite());
    }

    public int hashCode() {
        return Objects.hash(this.positionX, this.positionY);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cell cell = (Cell)o;
        return this.positionX == cell.positionX && this.positionY == cell.positionY;
    }

    public String toString() {
        return "Cell{positionX=" + this.positionX + ", positionY=" + this.positionY + ", paths=" + String.valueOf(this.paths) + ", value=" + this.value + "}";
    }

    @Generated
    public Cell(int positionX, int positionY) {
        this.positionX = positionX;
        this.positionY = positionY;
    }

    @Generated
    public int getPositionX() {
        return this.positionX;
    }

    @Generated
    public int getPositionY() {
        return this.positionY;
    }

    @Generated
    public EnumMap<Direction, Cell> getNeighbours() {
        return this.neighbours;
    }

    @Generated
    public Set<Direction> getPaths() {
        return this.paths;
    }

    @Generated
    public float getValue() {
        return this.value;
    }

    @Generated
    public void setValue(float value) {
        this.value = value;
    }
}

