/*
 * Decompiled with CFR 0.152.
 */
package dev.aisandbox.server.simulation.coingame;

import dev.aisandbox.server.engine.Theme;
import dev.aisandbox.server.engine.output.OutputConstants;
import dev.aisandbox.server.engine.widget.GraphicsUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CoinIcons {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CoinIcons.class);
    public static final int PILE_WIDTH = 290;
    public static final int ROW_HEIGHT = 80;
    private static final int COIN_SPACE = 20;
    private static final int COIN_IMAGE_WIDTH = 241;
    private static final int COIN_IMAGE_HEIGHT = 91;
    public static final int COINS_HEIGHT = 491;

    public static BufferedImage[] getRowImages(int rowCount, Theme theme) {
        BufferedImage[] images = new BufferedImage[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            images[i] = new BufferedImage(290, 80, 2);
            Graphics2D g = images[i].createGraphics();
            GraphicsUtils.setupRenderingHints(g);
            g.setColor(Color.BLACK);
            GraphicsUtils.drawCenteredText(g, 0, 0, 290, 76, "Row " + i, OutputConstants.HEADER_FONT, theme.getText());
        }
        return images;
    }

    public static BufferedImage[] getCoinImages(int cointCount, Theme theme) throws IOException {
        BufferedImage[] images = new BufferedImage[cointCount + 1];
        BufferedImage coinImage = ImageIO.read(CoinIcons.class.getResourceAsStream("/images/coins/gold.png"));
        log.debug("loaded coins image of width {} and height {}", (Object)coinImage.getWidth(), (Object)coinImage.getHeight());
        Font font = new Font("Arial", 1, 20);
        for (int i = 0; i <= cointCount; ++i) {
            images[i] = new BufferedImage(290, 491, 2);
            Graphics2D g = images[i].createGraphics();
            GraphicsUtils.setupRenderingHints(g);
            int xPadding = (290 - coinImage.getWidth()) / 2;
            for (int j = 1; j <= i; ++j) {
                g.drawImage((Image)coinImage, xPadding, 491 - coinImage.getHeight() - (j - 1) * 20, null);
            }
            g.setColor(Color.DARK_GRAY);
            g.fillRect(105, 451, 80, 40);
            GraphicsUtils.drawCenteredText(g, 105, 445, 80, 40, Integer.toString(i), OutputConstants.HEADER_FONT, theme.getText());
        }
        return images;
    }

    @Generated
    private CoinIcons() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

