/*
 * Decompiled with CFR 0.152.
 */
package dev.aisandbox.server.engine.widget;

import dev.aisandbox.server.engine.Theme;
import dev.aisandbox.server.engine.widget.PieChartWidget;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import lombok.Generated;

public class RollingPieChartWidget {
    private final int width;
    private final int height;
    private final int window;
    private final String title;
    private final Theme theme;
    private final List<String> values = new ArrayList<String>();
    private final Map<String, Color> sliceColours = new HashMap<String, Color>();
    private BufferedImage image = null;

    public static RollingPieChartWidgetBuilder builder() {
        return new RollingPieChartWidgetBuilder();
    }

    public void addValue(String value, Color valueColour) {
        this.values.add(value);
        this.sliceColours.put(value, valueColour);
        while (this.values.size() > this.window) {
            this.values.removeFirst();
        }
        this.image = null;
    }

    public BufferedImage getImage() {
        if (this.image == null) {
            PieChartWidget pie = new PieChartWidget(this.width, this.height, this.title, this.theme);
            TreeMap counts = new TreeMap();
            this.values.forEach(value -> counts.put(value, counts.compute(value, (k, v) -> v == null ? 1.0 : v + 1.0)));
            ArrayList<PieChartWidget.Slice> slices = new ArrayList<PieChartWidget.Slice>();
            for (Map.Entry entry : counts.entrySet()) {
                slices.add(new PieChartWidget.Slice((String)entry.getKey(), (Double)entry.getValue(), this.sliceColours.get(entry.getKey())));
            }
            pie.setPie(slices);
            this.image = pie.getImage();
        }
        return this.image;
    }

    @Generated
    public RollingPieChartWidget(int width, int height, int window, String title, Theme theme) {
        this.width = width;
        this.height = height;
        this.window = window;
        this.title = title;
        this.theme = theme;
    }

    public static class RollingPieChartWidgetBuilder {
        private int width = 200;
        private int height = 200;
        private String title = "Pie Chart";
        private int window = 200;
        private Theme theme = Theme.LIGHT;

        public RollingPieChartWidget build() {
            return new RollingPieChartWidget(this.width, this.height, this.window, this.title, this.theme);
        }

        @Generated
        public RollingPieChartWidgetBuilder width(int width) {
            this.width = width;
            return this;
        }

        @Generated
        public RollingPieChartWidgetBuilder height(int height) {
            this.height = height;
            return this;
        }

        @Generated
        public RollingPieChartWidgetBuilder title(String title) {
            this.title = title;
            return this;
        }

        @Generated
        public RollingPieChartWidgetBuilder window(int window) {
            this.window = window;
            return this;
        }

        @Generated
        public RollingPieChartWidgetBuilder theme(Theme theme) {
            this.theme = theme;
            return this;
        }
    }
}

