/*
 * Decompiled with CFR 0.152.
 */
package dev.aisandbox.server.engine.network;

import dev.aisandbox.server.engine.output.OutputRenderer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.SynchronousQueue;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkAgentConnectionThread
extends Thread {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NetworkAgentConnectionThread.class);
    private final String agentName;
    private final ServerSocket serverSocket;
    private final SynchronousQueue<ConnectionPair> connectionQueue;
    private final OutputRenderer renderer;

    @Override
    public void run() {
        log.info("Opening network agent for {}", (Object)this.agentName);
        try {
            Socket socket = this.serverSocket.accept();
            log.info("{} connected from {}", (Object)this.agentName, (Object)socket.getRemoteSocketAddress());
            this.renderer.write(this.agentName + " connected from " + String.valueOf(socket.getRemoteSocketAddress()));
            ConnectionPair connectionPair = new ConnectionPair(socket.getInputStream(), socket.getOutputStream());
            this.connectionQueue.put(connectionPair);
        }
        catch (IOException e) {
            log.warn("Error while opening network agent for {}", (Object)this.agentName, (Object)e);
        }
        catch (InterruptedException e) {
            log.warn("Canceled network connection for {}", (Object)this.agentName);
        }
    }

    @Generated
    public NetworkAgentConnectionThread(String agentName, ServerSocket serverSocket, SynchronousQueue<ConnectionPair> connectionQueue, OutputRenderer renderer) {
        this.agentName = agentName;
        this.serverSocket = serverSocket;
        this.connectionQueue = connectionQueue;
        this.renderer = renderer;
    }

    public record ConnectionPair(InputStream input, OutputStream output) {
    }
}

