/*
 * Decompiled with CFR 0.152.
 */
package dev.aisandbox.server.simulation.twisty;

import dev.aisandbox.server.engine.Agent;
import dev.aisandbox.server.engine.Simulation;
import dev.aisandbox.server.engine.Theme;
import dev.aisandbox.server.engine.exception.SimulationException;
import dev.aisandbox.server.engine.output.OutputRenderer;
import dev.aisandbox.server.engine.widget.RollingIconWidget;
import dev.aisandbox.server.engine.widget.RollingSuccessStatisticsWidget;
import dev.aisandbox.server.engine.widget.TitleWidget;
import dev.aisandbox.server.simulation.twisty.NotExistentMoveException;
import dev.aisandbox.server.simulation.twisty.model.MoveResult;
import dev.aisandbox.server.simulation.twisty.model.TwistyPuzzle;
import dev.aisandbox.server.simulation.twisty.proto.TwistyAction;
import dev.aisandbox.server.simulation.twisty.proto.TwistyResult;
import dev.aisandbox.server.simulation.twisty.proto.TwistySignal;
import dev.aisandbox.server.simulation.twisty.proto.TwistyState;
import java.awt.Graphics2D;
import java.awt.Image;
import java.util.Random;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TwistySimulation
implements Simulation {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TwistySimulation.class);
    private static final int SCRAMBLE_MOVES = 200;
    private static final String RESET_MOVE = "reset";
    private static final int WIDGET_WIDTH = 597;
    private static final int WIDGET_HEIGHT = 415;
    private static final int MAX_STEPS = 50000;
    private final Agent agent;
    private final TwistyPuzzle puzzle;
    private final boolean startSolved;
    private final Theme theme;
    private final Random random;
    private final String sessionID = UUID.randomUUID().toString();
    private final TitleWidget titleWidget;
    private final RollingIconWidget moveHistoryWidget;
    private final RollingSuccessStatisticsWidget statsWidget;
    int moves;
    int obtmMoves;
    private String episodeID;

    public TwistySimulation(Agent agent, TwistyPuzzle puzzle, boolean startSolved, Theme theme, Random random) {
        this.agent = agent;
        this.puzzle = puzzle;
        this.startSolved = startSolved;
        this.theme = theme;
        this.random = random;
        this.titleWidget = TitleWidget.builder().title("Twisty Puzzle - " + puzzle.getPuzzleName()).theme(theme).build();
        this.moveHistoryWidget = RollingIconWidget.builder().width(597).height(415).iconWidth(60).iconHeight(85).title("Moves").theme(theme).build();
        this.statsWidget = RollingSuccessStatisticsWidget.builder().width(597).height(415).theme(theme).build();
        this.initialisePuzzle();
    }

    public void initialisePuzzle() {
        this.puzzle.resetPuzzle();
        if (!this.startSolved) {
            this.scramblePuzzle();
        }
        this.moves = 0;
        this.obtmMoves = 0;
        this.moveHistoryWidget.clearIcons();
        this.episodeID = UUID.randomUUID().toString();
    }

    private void scramblePuzzle() {
        for (int i = 0; i < 200; ++i) {
            try {
                String randomMove = this.puzzle.getMoveList().get(this.random.nextInt(this.puzzle.getMoveList().size()));
                this.puzzle.applyMove(randomMove);
                continue;
            }
            catch (NotExistentMoveException e) {
                log.error("Non existent move when trying a move defined in the class", (Throwable)e);
            }
        }
    }

    @Override
    public void step(OutputRenderer output) throws SimulationException {
        if (this.moves == 0) {
            output.display();
        }
        TwistyState.Builder builder = TwistyState.newBuilder();
        builder.setSteps(this.moves);
        builder.setObtmMoves(this.obtmMoves);
        builder.setEpisodeID(this.episodeID);
        builder.setSessionID(this.sessionID);
        builder.setState(this.puzzle.getState());
        builder.setPuzzleName(this.puzzle.getPuzzleName());
        builder.addAllValidMoves(this.puzzle.getMoveList());
        this.agent.send(builder.build());
        TwistyAction action = this.agent.receive(TwistyAction.class);
        log.info("action: {}", (Object)action.getMove());
        if (RESET_MOVE.equalsIgnoreCase(action.getMove())) {
            this.agent.send(TwistyResult.newBuilder().setState(this.puzzle.getState()).setSignal(TwistySignal.LOSE).build());
            this.statsWidget.addFailure();
            this.initialisePuzzle();
        } else {
            MoveResult result = this.puzzle.applyMove(action.getMove());
            this.moveHistoryWidget.addIcon(result.icon());
            ++this.moves;
            this.obtmMoves += result.cost();
            if (this.puzzle.isSolved()) {
                log.info("solved");
                this.agent.send(TwistyResult.newBuilder().setState(this.puzzle.getState()).setSignal(TwistySignal.WIN).build());
                this.statsWidget.addSuccess(this.obtmMoves);
                output.display();
                this.initialisePuzzle();
            } else if (this.moves == 50000) {
                log.info("max moves");
                this.agent.send(TwistyResult.newBuilder().setState(this.puzzle.getState()).setSignal(TwistySignal.LOSE).build());
                this.statsWidget.addFailure();
                output.display();
                this.initialisePuzzle();
            } else {
                this.agent.send(TwistyResult.newBuilder().setState(this.puzzle.getState()).setSignal(TwistySignal.CONTINUE).build());
                output.display();
            }
        }
    }

    @Override
    public void visualise(Graphics2D graphics2D) {
        graphics2D.setColor(this.theme.getBase());
        graphics2D.fillRect(0, 0, 1920, 1080);
        graphics2D.drawImage((Image)this.titleWidget.getImage(), 0, 50, null);
        this.puzzle.drawPuzzle(graphics2D, 50, 150, this.theme);
        graphics2D.drawImage((Image)this.theme.getLogoImage(), 1779, 21, null);
        graphics2D.drawImage((Image)this.statsWidget.getImage(), 1273, 150, null);
        graphics2D.drawImage((Image)this.moveHistoryWidget.getImage(), 1273, 615, null);
    }
}

