/*
 * Decompiled with CFR 0.152.
 */
package dev.aisandbox.server.engine.widget;

import dev.aisandbox.server.engine.Theme;
import dev.aisandbox.server.engine.output.OutputConstants;
import dev.aisandbox.server.engine.widget.GraphicsUtils;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RollingIconWidget {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RollingIconWidget.class);
    private static final int PADDING = 16;
    private final int width;
    private final int height;
    private final int iconWidth;
    private final int iconHeight;
    private final int maxXCount;
    private final int maxMemory;
    private final boolean useCache;
    private final String title;
    private final Theme theme;
    private final List<BufferedImage> images = new ArrayList<BufferedImage>();
    private final int iconOriginX;
    private final int iconOriginY;
    private BufferedImage cachedImage = null;

    public RollingIconWidget(int width, int height, int iconWidth, int iconHeight, boolean useCache, String title, Theme theme) {
        this.width = width;
        this.height = height;
        this.iconWidth = iconWidth;
        this.iconHeight = iconHeight;
        this.useCache = useCache;
        this.title = title;
        this.theme = theme;
        this.maxXCount = (width - 32) / iconWidth;
        int maxYCount = (height - 18 - 48) / iconHeight;
        this.maxMemory = this.maxXCount * maxYCount;
        log.debug("Setting up rolling icon widget with max number of icons = {}", (Object)this.maxMemory);
        this.iconOriginX = (width - 32 - iconWidth * this.maxXCount) / 2 + 16;
        this.iconOriginY = (height - 18 - 48 - iconHeight * maxYCount) / 2 + 18 + 32;
    }

    public static RollingIconWidgetBuilder builder() {
        return new RollingIconWidgetBuilder();
    }

    public void clearIcons() {
        log.info("Clear icons");
        this.images.clear();
        this.cachedImage = null;
    }

    public void addIcon(@NonNull BufferedImage iconImage) {
        if (iconImage == null) {
            throw new NullPointerException("iconImage is marked non-null but is null");
        }
        assert (iconImage.getWidth() == this.iconWidth && iconImage.getHeight() == this.iconHeight);
        this.images.add(iconImage);
        while (this.images.size() > this.maxMemory) {
            this.images.removeFirst();
        }
        log.info("Adding icon: {} / {}", (Object)this.images.size(), (Object)this.maxMemory);
        this.cachedImage = null;
    }

    public BufferedImage getImage() {
        BufferedImage image = this.cachedImage;
        if (image == null) {
            image = new BufferedImage(this.width, this.height, 2);
            Graphics2D graphics2D = image.createGraphics();
            GraphicsUtils.setupRenderingHints(graphics2D);
            graphics2D.setColor(this.theme.getBackground());
            graphics2D.fillRect(0, 0, this.width, this.height);
            graphics2D.setColor(this.theme.getText());
            GraphicsUtils.drawCenteredText(graphics2D, 0, 16, this.width, 18, this.title, OutputConstants.WIDGET_TITLE_FONT, this.theme.getText());
            log.info("Drawing image: {} / {}", (Object)this.images.size(), (Object)this.maxMemory);
            for (int i = 0; i < this.images.size(); ++i) {
                BufferedImage icon = this.images.get(i);
                int dx = i % this.maxXCount;
                int dy = i / this.maxXCount;
                graphics2D.drawImage((Image)icon, this.iconOriginX + dx * this.iconWidth, this.iconOriginY + dy * this.iconHeight, null);
            }
            if (this.useCache) {
                this.cachedImage = image;
            }
        }
        return image;
    }

    public static class RollingIconWidgetBuilder {
        private int width = 200;
        private int height = 200;
        private int iconWidth = 50;
        private int iconHeight = 50;
        private boolean useCache = false;
        private String title = "Recent Icons";
        private Theme theme = Theme.LIGHT;

        public RollingIconWidget build() {
            return new RollingIconWidget(this.width, this.height, this.iconWidth, this.iconHeight, this.useCache, this.title, this.theme);
        }

        @Generated
        public RollingIconWidgetBuilder width(int width) {
            this.width = width;
            return this;
        }

        @Generated
        public RollingIconWidgetBuilder height(int height) {
            this.height = height;
            return this;
        }

        @Generated
        public RollingIconWidgetBuilder iconWidth(int iconWidth) {
            this.iconWidth = iconWidth;
            return this;
        }

        @Generated
        public RollingIconWidgetBuilder iconHeight(int iconHeight) {
            this.iconHeight = iconHeight;
            return this;
        }

        @Generated
        public RollingIconWidgetBuilder useCache(boolean useCache) {
            this.useCache = useCache;
            return this;
        }

        @Generated
        public RollingIconWidgetBuilder title(String title) {
            this.title = title;
            return this;
        }

        @Generated
        public RollingIconWidgetBuilder theme(Theme theme) {
            this.theme = theme;
            return this;
        }
    }
}

