/*
 * Decompiled with CFR 0.152.
 */
package dev.aisandbox.server.engine.network;

import com.google.protobuf.GeneratedMessage;
import dev.aisandbox.server.engine.Agent;
import dev.aisandbox.server.engine.exception.SimulationException;
import dev.aisandbox.server.engine.exception.SimulationSetupException;
import dev.aisandbox.server.engine.network.NetworkAgentConnectionThread;
import dev.aisandbox.server.engine.output.OutputRenderer;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.concurrent.SynchronousQueue;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkAgent
implements Agent {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NetworkAgent.class);
    private static final int MAX_PORT_TRIES = 10;
    private final String agentName;
    private final ServerSocket serverSocket;
    private final OutputRenderer renderer;
    private final SynchronousQueue<NetworkAgentConnectionThread.ConnectionPair> connectionQueue = new SynchronousQueue();
    private NetworkAgentConnectionThread.ConnectionPair connectionPair = null;

    public NetworkAgent(String agentName, int defaultPort, boolean openExternal, OutputRenderer renderer) throws SimulationSetupException {
        this.agentName = agentName;
        this.renderer = renderer;
        this.serverSocket = this.getServerSocket(defaultPort, openExternal);
        NetworkAgentConnectionThread networkAgentConnectionThread = new NetworkAgentConnectionThread(agentName, this.serverSocket, this.connectionQueue, renderer);
        networkAgentConnectionThread.start();
    }

    private ServerSocket getServerSocket(int defaultPort, boolean openExternal) throws SimulationSetupException {
        int targetPort = defaultPort;
        int tries = 0;
        ServerSocket socket = null;
        while (socket == null && tries < 10) {
            try {
                if (openExternal) {
                    log.info("Trying to create server socket on port {}", (Object)targetPort);
                    socket = new ServerSocket(targetPort);
                } else {
                    log.info("Trying to create server socket on loopback port {}", (Object)targetPort);
                    socket = new ServerSocket(targetPort, 1, InetAddress.getLoopbackAddress());
                }
                log.info("Successfully created server socket on port {}", (Object)targetPort);
                this.renderer.write("Connect " + this.agentName + " to port " + targetPort);
            }
            catch (IOException e) {
                log.warn("Failed to create server socket with port {}", (Object)targetPort, (Object)e);
                ++tries;
                ++targetPort;
            }
        }
        if (socket == null) {
            this.renderer.write("Failed to create server socket.");
            log.error("Unable to create server socket for {} after {} tries", (Object)this.agentName, (Object)10);
            throw new SimulationSetupException("Unable to create server socket for " + this.agentName);
        }
        return socket;
    }

    @Override
    public void send(GeneratedMessage o) throws SimulationException {
        if (o == null) {
            log.warn("Trying to send a null object to {}", (Object)this.agentName);
        } else {
            log.debug("Sending '{}' to {}", (Object)o.toString().replaceAll("[\\n\\r]", ""), (Object)this.agentName);
        }
        try {
            if (this.connectionPair == null) {
                this.connectionPair = this.connectionQueue.take();
            }
            o.writeDelimitedTo(this.connectionPair.output());
        }
        catch (IOException e) {
            log.error("IO exception while sending message to {}", (Object)this.agentName, (Object)e);
            throw new SimulationException("IO Error sending to " + this.agentName);
        }
        catch (InterruptedException e) {
            throw new SimulationException("Sending message while shutting down");
        }
    }

    @Override
    public <T extends GeneratedMessage> T receive(Class<T> responseType) throws SimulationException {
        try {
            if (this.connectionPair == null) {
                this.connectionPair = this.connectionQueue.take();
            }
            log.debug("Asking {} thread for response type {}", (Object)this.agentName, (Object)responseType.getSimpleName());
            Method readDelimited = responseType.getMethod("parseDelimitedFrom", InputStream.class);
            GeneratedMessage response = (GeneratedMessage)readDelimited.invoke(null, this.connectionPair.input());
            if (response == null) {
                log.debug("Received null response from {}", (Object)this.agentName);
                throw new SimulationException("Network connection closed by " + this.agentName);
            }
            return (T)((GeneratedMessage)responseType.cast(response));
        }
        catch (ClassCastException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.error("Error decoding message from {}, expecting {}", new Object[]{this.agentName, responseType.getSimpleName(), e});
            throw new SimulationException("Error decoding generated message from " + this.agentName + " expecting " + responseType.getSimpleName());
        }
        catch (InterruptedException e) {
            throw new SimulationException("Reading message while shutting down");
        }
    }

    @Override
    public void close() {
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            log.error("Error closing server socket", (Throwable)e);
        }
    }

    @Override
    @Generated
    public String getAgentName() {
        return this.agentName;
    }
}

