/*
 * Decompiled with CFR 0.152.
 */
package dev.aisandbox.server.engine.maths;

import dev.aisandbox.server.engine.maths.BinContents;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;

public final class StatisticsUtils {
    public static Pair<Double, Double> getMinMax(List<Double> values) {
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        for (double value : values) {
            min = Math.min(min, value);
            max = Math.max(max, value);
        }
        return Pair.of((Object)min, (Object)max);
    }

    public static List<BinContents> getBinnedValues(List<Double> values, List<Double> binStarts, List<Double> binEnds) {
        assert (binStarts.size() == binEnds.size());
        int[] bincounts = new int[binStarts.size()];
        for (double value : values) {
            boolean found = false;
            for (int i = 0; !found && i < binStarts.size(); ++i) {
                if (!(binStarts.get(i) <= value) || !(binEnds.get(i) >= value)) continue;
                int n = i;
                bincounts[n] = bincounts[n] + 1;
                found = true;
            }
            assert (found) : "Value " + value + " out of binning range " + String.valueOf(binStarts.getFirst()) + " to " + String.valueOf(binEnds.getFirst());
        }
        double[] bindensity = new double[binStarts.size()];
        for (int i = 0; i < binStarts.size(); ++i) {
            bindensity[i] = binStarts.get(i) / (binEnds.get(i) - binStarts.get(i));
        }
        ArrayList<BinContents> bins = new ArrayList<BinContents>();
        for (int i = 0; i < binStarts.size(); ++i) {
            bins.add(new BinContents(binStarts.get(i), binEnds.get(i), bincounts[i], bindensity[i]));
        }
        return bins;
    }

    @Generated
    private StatisticsUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

