/*
 * Decompiled with CFR 0.152.
 */
package dev.aisandbox.server.engine;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Objects;
import javax.imageio.ImageIO;
import lombok.Generated;

public enum Theme {
    LIGHT(Color.decode("#f0f0f0"), Color.decode("#ffffff"), Color.decode("#efefef"), Color.decode("#000066"), Color.decode("#660000"), Color.decode("#fffaf0"), Color.decode("#4C4C4D"), Color.decode("#005500"), Color.decode("#008800"), "/images/AILogo.png"),
    DARK(Color.decode("#1e1f22"), Color.decode("#2b2d30"), Color.decode("#343538"), Color.decode("#5489f6"), Color.decode("#db5c5c"), Color.decode("#cc895b"), Color.white, Color.decode("#005500"), Color.decode("#003300"), "/images/AILogoW.png"),
    MIDNIGHT(Color.decode("#0f1419"), Color.decode("#1a2332"), Color.decode("#2d3748"), Color.decode("#4299e1"), Color.decode("#63b3ed"), Color.decode("#9f7aea"), Color.decode("#e2e8f0"), Color.decode("#2a4365"), Color.decode("#1a365d"), "/images/AILogoW.png"),
    WARM(Color.decode("#faf7f2"), Color.decode("#fffef9"), Color.decode("#f0ede6"), Color.decode("#d69e2e"), Color.decode("#c05621"), Color.decode("#ed8936"), Color.decode("#744210"), Color.decode("#68d391"), Color.decode("#48bb78"), "/images/AILogo.png"),
    FOREST(Color.decode("#f7f9f7"), Color.decode("#fdfefd"), Color.decode("#e6f4ea"), Color.decode("#2d7d32"), Color.decode("#388e3c"), Color.decode("#8bc34a"), Color.decode("#1b5e20"), Color.decode("#4caf50"), Color.decode("#2e7d32"), "/images/AILogo.png");

    private final Color base;
    private final Color background;
    private final Color border;
    private final Color primary;
    private final Color secondary;
    private final Color accent;
    private final Color text;
    private final Color baize;
    private final Color baizeBorder;
    private final String logo;
    private final BufferedImage logoImage;

    private Theme(Color base, Color background, Color border, Color primary, Color secondary, Color accent, Color text, Color baize, Color baizeBorder, String logo) {
        this.base = base;
        this.background = background;
        this.border = border;
        this.primary = primary;
        this.secondary = secondary;
        this.accent = accent;
        this.text = text;
        this.baize = baize;
        this.baizeBorder = baizeBorder;
        this.logo = logo;
        BufferedImage tempImage = null;
        try {
            tempImage = ImageIO.read(Objects.requireNonNull(Theme.class.getResourceAsStream(logo)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.logoImage = tempImage;
    }

    @Generated
    public Color getBase() {
        return this.base;
    }

    @Generated
    public Color getBackground() {
        return this.background;
    }

    @Generated
    public Color getBorder() {
        return this.border;
    }

    @Generated
    public Color getPrimary() {
        return this.primary;
    }

    @Generated
    public Color getSecondary() {
        return this.secondary;
    }

    @Generated
    public Color getAccent() {
        return this.accent;
    }

    @Generated
    public Color getText() {
        return this.text;
    }

    @Generated
    public Color getBaize() {
        return this.baize;
    }

    @Generated
    public Color getBaizeBorder() {
        return this.baizeBorder;
    }

    @Generated
    public String getLogo() {
        return this.logo;
    }

    @Generated
    public BufferedImage getLogoImage() {
        return this.logoImage;
    }

    @Generated
    private Theme(Color base, Color background, Color border, Color primary, Color secondary, Color accent, Color text, Color baize, Color baizeBorder, String logo, BufferedImage logoImage) {
        this.base = base;
        this.background = background;
        this.border = border;
        this.primary = primary;
        this.secondary = secondary;
        this.accent = accent;
        this.text = text;
        this.baize = baize;
        this.baizeBorder = baizeBorder;
        this.logo = logo;
        this.logoImage = logoImage;
    }
}

