/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.descriptive;

import org.apache.commons.numbers.core.Sum;
import org.apache.commons.statistics.descriptive.IntVariance;
import org.apache.commons.statistics.descriptive.LongVariance;
import org.apache.commons.statistics.descriptive.SumOfSquaredDeviations;

class SumOfCubedDeviations
extends SumOfSquaredDeviations {
    static final int LENGTH_TWO = 2;
    protected double sumCubedDev;

    SumOfCubedDeviations() {
    }

    SumOfCubedDeviations(SumOfCubedDeviations source) {
        super(source);
        this.sumCubedDev = source.sumCubedDev;
    }

    SumOfCubedDeviations(double sc, SumOfSquaredDeviations ss) {
        super(ss);
        this.sumCubedDev = sc;
    }

    SumOfCubedDeviations(double sc, double ss, double m1, long n) {
        super(ss, m1, n);
        this.sumCubedDev = sc;
    }

    static SumOfCubedDeviations of(double ... values) {
        if (values.length == 0) {
            return new SumOfCubedDeviations();
        }
        return SumOfCubedDeviations.create(SumOfSquaredDeviations.of(values), values);
    }

    static SumOfCubedDeviations create(Sum sum, double[] values) {
        if (values.length == 0) {
            return new SumOfCubedDeviations();
        }
        return SumOfCubedDeviations.create(SumOfSquaredDeviations.create(sum, values), values);
    }

    private static SumOfCubedDeviations create(SumOfSquaredDeviations ss, double[] values) {
        double xbar = ss.getFirstMoment();
        if (!Double.isFinite(xbar)) {
            return new SumOfCubedDeviations(Double.NaN, ss);
        }
        if (!Double.isFinite(ss.sumSquaredDev)) {
            return new SumOfCubedDeviations(values.length <= 2 ? 0.0 : Double.NaN, ss);
        }
        double s = 0.0;
        if (values.length > 2) {
            for (double x : values) {
                s += SumOfCubedDeviations.pow3(x - xbar);
            }
        }
        return new SumOfCubedDeviations(s, ss);
    }

    static SumOfCubedDeviations of(int ... values) {
        if (values.length == 0) {
            return new SumOfCubedDeviations();
        }
        IntVariance variance = IntVariance.of(values);
        double xbar = variance.computeMean();
        double ss = variance.computeSumOfSquaredDeviations();
        double sc = 0.0;
        if (values.length > 2) {
            int[] nArray = values;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                double x = nArray[i];
                sc += SumOfCubedDeviations.pow3(x - xbar);
            }
        }
        return new SumOfCubedDeviations(sc, ss, xbar, values.length);
    }

    static SumOfCubedDeviations of(long ... values) {
        if (values.length == 0) {
            return new SumOfCubedDeviations();
        }
        LongVariance variance = LongVariance.of(values);
        double xbar = variance.computeMean();
        double ss = variance.computeSumOfSquaredDeviations();
        double sc = 0.0;
        if (values.length > 2) {
            long[] lArray = values;
            int n = lArray.length;
            for (int i = 0; i < n; ++i) {
                double x = lArray[i];
                sc += SumOfCubedDeviations.pow3(x - xbar);
            }
        }
        return new SumOfCubedDeviations(sc, ss, xbar, values.length);
    }

    private static double pow3(double x) {
        return x * x * x;
    }

    @Override
    public void accept(double value) {
        double ss = this.sumSquaredDev;
        double np = this.n;
        super.accept(value);
        this.sumCubedDev = this.sumCubedDev - ss * this.nDev * 6.0 + (np - 1.0) * np * this.nDev * this.nDev * this.dev * 8.0;
    }

    double getSumOfCubedDeviations() {
        return Double.isFinite(this.getFirstMoment()) ? this.sumCubedDev : Double.NaN;
    }

    SumOfCubedDeviations combine(SumOfCubedDeviations other) {
        if (this.n == 0L) {
            this.sumCubedDev = other.sumCubedDev;
        } else if (other.n != 0L) {
            double halfDiffOfMean = this.getFirstMomentHalfDifference(other);
            this.sumCubedDev += other.sumCubedDev;
            if (halfDiffOfMean != 0.0) {
                double n1 = this.n;
                double n2 = other.n;
                if (n1 == n2) {
                    this.sumCubedDev += (this.sumSquaredDev - other.sumSquaredDev) * halfDiffOfMean * 3.0;
                } else {
                    double n1n2 = n1 + n2;
                    double dm = 2.0 * (halfDiffOfMean / n1n2);
                    this.sumCubedDev += (this.sumSquaredDev * n2 - other.sumSquaredDev * n1) * dm * 3.0 + (n2 - n1) * (n1 * n2) * SumOfCubedDeviations.pow3(dm) * n1n2;
                }
            }
        }
        super.combine(other);
        return this;
    }
}

