/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.descriptive;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.apache.commons.numbers.core.DD;
import org.apache.commons.statistics.descriptive.IntMath;
import org.apache.commons.statistics.descriptive.UInt128;

final class Int128 {
    private static final long MASK32 = 0xFFFFFFFFL;
    private long lo;
    private long hi;

    private Int128() {
    }

    private Int128(long x) {
        this.lo = x;
    }

    Int128(long hi, long lo) {
        this.lo = lo;
        this.hi = hi;
    }

    static Int128 create() {
        return new Int128();
    }

    static Int128 of(long x) {
        return new Int128(x);
    }

    void add(long x) {
        long y = this.lo;
        long r = y + x;
        if (((y ^ r) & (x ^ r)) < 0L) {
            this.hi += x < 0L ? -1L : 1L;
        }
        this.lo = r;
    }

    void add(Int128 x) {
        long l = x.lo;
        long h = x.hi;
        this.add(l);
        this.hi += h;
    }

    UInt128 squareLow() {
        long x = this.lo;
        long upper = IntMath.squareHigh(x);
        return new UInt128(upper, x * x);
    }

    BigInteger toBigInteger() {
        long h = this.hi;
        long l = this.lo;
        if (h == 0L) {
            return BigInteger.valueOf(l);
        }
        if (l == 0L) {
            return BigInteger.valueOf(h).shiftLeft(64);
        }
        int sign = 1;
        if ((h ^ l) < 0L) {
            if (h >= 0L) {
                --h;
            } else {
                h ^= 0xFFFFFFFFFFFFFFFFL;
                l = -l;
                sign = -1;
            }
        } else if (h < 0L) {
            h = -h;
            l = -l;
            sign = -1;
        }
        return new BigInteger(sign, ByteBuffer.allocate(16).putLong(h).putLong(l).array());
    }

    double toDouble() {
        long h = this.hi;
        long l = this.lo;
        if (h == 0L) {
            return l;
        }
        if (l == 0L) {
            return (double)h * 1.8446744073709552E19;
        }
        int sign = 1;
        if ((h ^ l) < 0L) {
            if (h >= 0L) {
                --h;
            } else {
                h ^= 0xFFFFFFFFFFFFFFFFL;
                l = -l;
                sign = -1;
            }
        } else if (h < 0L) {
            h = -h;
            l = -l;
            sign = -1;
        }
        double x = IntMath.uint128ToDouble(h, l);
        return sign < 0 ? -x : x;
    }

    DD toDD() {
        return DD.of((long)this.lo).add((double)(this.hi & 0xFFFFFFFFL) * 1.8446744073709552E19).add((double)(this.hi >> 32) * 7.922816251426434E28);
    }

    int toIntExact() {
        return Math.toIntExact(this.toLongExact());
    }

    long toLongExact() {
        if (this.hi != 0L) {
            throw new ArithmeticException("long integer overflow");
        }
        return this.lo;
    }

    long lo64() {
        return this.lo;
    }

    long hi64() {
        return this.hi;
    }
}

