/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.descriptive;

import java.math.BigInteger;
import org.apache.commons.statistics.descriptive.IntStatistic;
import org.apache.commons.statistics.descriptive.StatisticAccumulator;
import org.apache.commons.statistics.descriptive.UInt128;
import org.apache.commons.statistics.descriptive.UInt96;

public final class IntSumOfSquares
implements IntStatistic,
StatisticAccumulator<IntSumOfSquares> {
    private static final int SMALL_SAMPLE = 10;
    private final UInt128 sumSq;

    private IntSumOfSquares() {
        this(UInt128.create());
    }

    private IntSumOfSquares(UInt128 sumSq) {
        this.sumSq = sumSq;
    }

    public static IntSumOfSquares create() {
        return new IntSumOfSquares();
    }

    public static IntSumOfSquares of(int ... values) {
        if (values.length < 10) {
            IntSumOfSquares stat = new IntSumOfSquares();
            for (int x : values) {
                stat.accept(x);
            }
            return stat;
        }
        UInt96 ss = UInt96.create();
        int end = values.length & 0xFFFFFFFE;
        for (int i = 0; i < end; i += 2) {
            long x = values[i];
            long y = values[i + 1];
            ss.addPositive(x * x + y * y);
        }
        if (end < values.length) {
            long x = values[end];
            ss.addPositive(x * x);
        }
        return new IntSumOfSquares(UInt128.of(ss));
    }

    UInt128 getSumOfSquares() {
        return this.sumSq;
    }

    @Override
    public void accept(int value) {
        this.sumSq.addPositive((long)value * (long)value);
    }

    @Override
    public int getAsInt() {
        return this.sumSq.toIntExact();
    }

    @Override
    public long getAsLong() {
        return this.sumSq.toLongExact();
    }

    @Override
    public double getAsDouble() {
        return this.sumSq.toDouble();
    }

    @Override
    public BigInteger getAsBigInteger() {
        return this.sumSq.toBigInteger();
    }

    @Override
    public IntSumOfSquares combine(IntSumOfSquares other) {
        this.sumSq.add(other.sumSq);
        return this;
    }
}

