/*
 * Decompiled with CFR 0.152.
 */
package dev.aisandbox.server.simulation.mine;

import lombok.Generated;

public class Cell {
    private boolean mine;
    private boolean covered = true;
    private boolean flagged;
    private int neighbours;

    public int getPlayerViewSprite() {
        return switch (this.getPlayerView()) {
            case 'F' -> 12;
            case 'f' -> 13;
            case '#' -> 11;
            case 'X' -> 10;
            case '.' -> 0;
            case '1' -> 1;
            case '2' -> 2;
            case '3' -> 3;
            case '4' -> 4;
            case '5' -> 5;
            case '6' -> 6;
            case '7' -> 7;
            case '8' -> 8;
            default -> 0;
        };
    }

    public char getPlayerView() {
        if (this.covered) {
            if (this.flagged) {
                if (this.mine) {
                    return 'F';
                }
                return 'f';
            }
            return '#';
        }
        if (this.mine) {
            return 'X';
        }
        if (this.neighbours == 0) {
            return '.';
        }
        return Integer.toString(this.neighbours).charAt(0);
    }

    @Generated
    public Cell() {
    }

    @Generated
    public boolean isMine() {
        return this.mine;
    }

    @Generated
    public boolean isCovered() {
        return this.covered;
    }

    @Generated
    public boolean isFlagged() {
        return this.flagged;
    }

    @Generated
    public int getNeighbours() {
        return this.neighbours;
    }

    @Generated
    public void setMine(boolean mine) {
        this.mine = mine;
    }

    @Generated
    public void setCovered(boolean covered) {
        this.covered = covered;
    }

    @Generated
    public void setFlagged(boolean flagged) {
        this.flagged = flagged;
    }

    @Generated
    public void setNeighbours(int neighbours) {
        this.neighbours = neighbours;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Cell)) {
            return false;
        }
        Cell other = (Cell)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isMine() != other.isMine()) {
            return false;
        }
        if (this.isCovered() != other.isCovered()) {
            return false;
        }
        if (this.isFlagged() != other.isFlagged()) {
            return false;
        }
        return this.getNeighbours() == other.getNeighbours();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Cell;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isMine() ? 79 : 97);
        result = result * 59 + (this.isCovered() ? 79 : 97);
        result = result * 59 + (this.isFlagged() ? 79 : 97);
        result = result * 59 + this.getNeighbours();
        return result;
    }

    @Generated
    public String toString() {
        return "Cell(mine=" + this.isMine() + ", covered=" + this.isCovered() + ", flagged=" + this.isFlagged() + ", neighbours=" + this.getNeighbours() + ")";
    }
}

