/*
 * Decompiled with CFR 0.152.
 */
package dev.aisandbox.server.simulation.common;

import lombok.Generated;

public record Card(CardValue cardValue, CardSuite cardSuite) {
    public static final int CARD_WIDTH = 240;
    public static final int CARD_HEIGHT = 336;

    public String getLongDescription() {
        return this.cardValue.getLongValue() + " of " + this.cardSuite.name().toLowerCase();
    }

    public String getShortDrescription() {
        return this.cardValue.getShortValue() + this.cardSuite.getValue();
    }

    public String getImageName() {
        return "/images/cards/" + this.cardValue.charValue + this.cardSuite.value + ".png";
    }

    public static enum CardValue {
        ACE("A", "Ace", 1, 14, 'A'),
        TWO("2", "2", 2, 2, '2'),
        THREE("3", "3", 3, 3, '3'),
        FOUR("4", "4", 4, 4, '4'),
        FIVE("5", "5", 5, 5, '5'),
        SIX("6", "6", 6, 6, '6'),
        SEVEN("7", "7", 7, 7, '7'),
        EIGHT("8", "8", 8, 8, '8'),
        NINE("9", "9", 9, 9, '9'),
        TEN("10", "10", 10, 10, 'T'),
        JACK("J", "Jack", 11, 11, 'J'),
        QUEEN("Q", "Queen", 12, 12, 'Q'),
        KING("K", "King", 13, 13, 'K');

        private final String shortValue;
        private final String longValue;
        private final int valueAceLow;
        private final int valueAceHigh;
        private final char charValue;

        @Generated
        public String getShortValue() {
            return this.shortValue;
        }

        @Generated
        public String getLongValue() {
            return this.longValue;
        }

        @Generated
        public int getValueAceLow() {
            return this.valueAceLow;
        }

        @Generated
        public int getValueAceHigh() {
            return this.valueAceHigh;
        }

        @Generated
        public char getCharValue() {
            return this.charValue;
        }

        @Generated
        private CardValue(String shortValue, String longValue, int valueAceLow, int valueAceHigh, char charValue) {
            this.shortValue = shortValue;
            this.longValue = longValue;
            this.valueAceLow = valueAceLow;
            this.valueAceHigh = valueAceHigh;
            this.charValue = charValue;
        }
    }

    public static enum CardSuite {
        HEARTS('H'),
        DIAMONDS('D'),
        CLUBS('C'),
        SPADES('S');

        private final char value;

        @Generated
        public char getValue() {
            return this.value;
        }

        @Generated
        private CardSuite(char value) {
            this.value = value;
        }
    }
}

