/*
 * Decompiled with CFR 0.152.
 */
package dev.aisandbox.server.simulation.bandit;

import dev.aisandbox.server.engine.Theme;
import dev.aisandbox.server.engine.maths.StatisticsUtils;
import dev.aisandbox.server.engine.widget.BaseGraph;
import dev.aisandbox.server.engine.widget.GraphicsUtils;
import dev.aisandbox.server.engine.widget.axis.NiceAxisScale;
import dev.aisandbox.server.engine.widget.axis.TightAxisScale;
import dev.aisandbox.server.simulation.bandit.model.Bandit;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;

public class BanditWidget {
    private final int width;
    private final int height;
    private final Theme theme;
    private List<Bandit> bandits = new ArrayList<Bandit>();
    private int activeBandit = -1;
    private BufferedImage image = null;

    public static BanditWidgetBuilder builder() {
        return new BanditWidgetBuilder();
    }

    public void setBandits(List<Bandit> bandits, int activeBandit) {
        this.bandits = bandits;
        this.activeBandit = activeBandit;
        this.image = null;
    }

    public BufferedImage getImage() {
        if (this.image == null) {
            if (this.bandits.isEmpty()) {
                this.image = GraphicsUtils.createBlankImage(this.width, this.height, this.theme.getBackground());
            } else {
                Pair<Double, Double> minMax = StatisticsUtils.getMinMax(Stream.concat(this.bandits.stream().flatMap(bandit -> Stream.of(bandit.getMean() - bandit.getStd(), bandit.getMean() + bandit.getStd())), Stream.of(Double.valueOf(0.0))).toList());
                NiceAxisScale yAxis = new NiceAxisScale((Double)minMax.getLeft(), (Double)minMax.getRight(), this.height / 40);
                TightAxisScale xAxis = new TightAxisScale(-0.4, (double)this.bandits.size() - 0.4, this.bandits.size());
                BaseGraph graph = new BaseGraph(this.width, this.height, "Multi-Arm Bandits", "Bandits", "Output", this.theme, xAxis, yAxis);
                for (int i = 0; i < this.bandits.size(); ++i) {
                    Color banditColor = this.theme.getBase();
                    Color banditOutline = this.theme.getPrimary();
                    if (this.activeBandit == i) {
                        banditColor = this.theme.getPrimary();
                        banditOutline = this.theme.getBase();
                    }
                    Bandit bandit2 = this.bandits.get(i);
                    graph.addBox((double)i - 0.2, bandit2.getMean() - bandit2.getStd(), (double)i + 0.2, bandit2.getMean() + bandit2.getStd(), banditColor, banditOutline);
                    graph.addLine((double)i - 0.2, bandit2.getMean(), (double)i + 0.2, bandit2.getMean(), banditOutline);
                }
                graph.addAxisAndTitle();
                this.image = graph.getImage();
            }
        }
        return this.image;
    }

    @Generated
    public BanditWidget(int width, int height, Theme theme) {
        this.width = width;
        this.height = height;
        this.theme = theme;
    }

    public static class BanditWidgetBuilder {
        private int width = 200;
        private int height = 200;
        private Theme theme = Theme.LIGHT;

        public BanditWidget build() {
            return new BanditWidget(this.width, this.height, this.theme);
        }

        @Generated
        public BanditWidgetBuilder width(int width) {
            this.width = width;
            return this;
        }

        @Generated
        public BanditWidgetBuilder height(int height) {
            this.height = height;
            return this;
        }

        @Generated
        public BanditWidgetBuilder theme(Theme theme) {
            this.theme = theme;
            return this;
        }
    }
}

