/*
 * Decompiled with CFR 0.152.
 */
package dev.aisandbox.server.fx;

import javafx.scene.image.ImageView;
import javafx.scene.layout.Region;

public class WrappedImageView
extends Region {
    private final ImageView imageView;

    public WrappedImageView(ImageView imageView) {
        this.imageView = imageView;
        this.getChildren().add((Object)imageView);
    }

    protected void layoutChildren() {
        double width = this.getWidth() - this.snappedLeftInset() - this.snappedRightInset();
        double height = this.getHeight() - this.snappedTopInset() - this.snappedBottomInset();
        this.imageView.setFitWidth(Math.max(1.0, width));
        this.imageView.setFitHeight(Math.max(1.0, height));
        double imageWidth = this.imageView.getBoundsInLocal().getWidth();
        double imageHeight = this.imageView.getBoundsInLocal().getHeight();
        double x = this.snappedLeftInset() + (width - imageWidth) / 2.0;
        double y = this.snappedTopInset() + (height - imageHeight) / 2.0;
        this.imageView.relocate(x, y);
    }
}

