/*
 * Decompiled with CFR 0.152.
 */
package dev.aisandbox.server.engine.widget;

import dev.aisandbox.server.engine.Theme;
import dev.aisandbox.server.engine.widget.BaseGraph;
import dev.aisandbox.server.engine.widget.GraphicsUtils;
import dev.aisandbox.server.engine.widget.axis.NiceAxisScale;
import dev.aisandbox.server.engine.widget.axis.TightAxisScale;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class RollingValueChartWidget {
    private final int width;
    private final int height;
    private final int window;
    private final String title;
    private final String xTitle;
    private final String yTitle;
    private final Theme theme;
    private final List<Double> values = new ArrayList<Double>();
    private int startIndex = 1;
    private BufferedImage image = null;

    public static RollingScoreChartBuilder builder() {
        return new RollingScoreChartBuilder();
    }

    public void addValue(double value) {
        this.values.add(value);
        while (this.values.size() > this.window) {
            this.values.removeFirst();
            ++this.startIndex;
        }
        this.image = null;
    }

    public void resetValues() {
        this.values.clear();
        this.image = null;
    }

    public BufferedImage getImage() {
        if (this.image == null) {
            if (this.values.isEmpty()) {
                this.image = GraphicsUtils.createBlankImage(this.width, this.height, this.theme.getBackground());
            } else {
                TightAxisScale xAxis = new TightAxisScale(this.startIndex, this.startIndex + this.values.size() - 1, this.width / 40);
                NiceAxisScale yAxis = new NiceAxisScale(this.values.stream().mapToDouble(value -> value).min().orElse(0.0), this.values.stream().mapToDouble(value -> value).max().orElse(0.0), this.height / 40);
                BaseGraph graph = new BaseGraph(this.width, this.height, this.title, this.xTitle, this.yTitle, this.theme, xAxis, yAxis);
                for (int i = 1; i < this.values.size(); ++i) {
                    graph.addLine(this.startIndex + i - 1, this.values.get(i - 1), this.startIndex + i, this.values.get(i), this.theme.getPrimary());
                }
                graph.addAxisAndTitle();
                this.image = graph.getImage();
            }
        }
        return this.image;
    }

    @Generated
    public RollingValueChartWidget(int width, int height, int window, String title, String xTitle, String yTitle, Theme theme) {
        this.width = width;
        this.height = height;
        this.window = window;
        this.title = title;
        this.xTitle = xTitle;
        this.yTitle = yTitle;
        this.theme = theme;
    }

    public static class RollingScoreChartBuilder {
        private int width = 200;
        private int height = 200;
        private int window = 200;
        private String title = "Values";
        private String yTitle = "Score";
        private String xTitle = "Episode";
        private Theme theme = Theme.LIGHT;

        public RollingValueChartWidget build() {
            return new RollingValueChartWidget(this.width, this.height, this.window, this.title, this.xTitle, this.yTitle, this.theme);
        }

        @Generated
        public RollingScoreChartBuilder width(int width) {
            this.width = width;
            return this;
        }

        @Generated
        public RollingScoreChartBuilder height(int height) {
            this.height = height;
            return this;
        }

        @Generated
        public RollingScoreChartBuilder window(int window) {
            this.window = window;
            return this;
        }

        @Generated
        public RollingScoreChartBuilder title(String title) {
            this.title = title;
            return this;
        }

        @Generated
        public RollingScoreChartBuilder yTitle(String yTitle) {
            this.yTitle = yTitle;
            return this;
        }

        @Generated
        public RollingScoreChartBuilder xTitle(String xTitle) {
            this.xTitle = xTitle;
            return this;
        }

        @Generated
        public RollingScoreChartBuilder theme(Theme theme) {
            this.theme = theme;
            return this;
        }
    }
}

