/*
 * Decompiled with CFR 0.152.
 */
package dev.aisandbox.server.engine.widget;

import dev.aisandbox.server.engine.Theme;
import dev.aisandbox.server.engine.output.OutputConstants;
import dev.aisandbox.server.engine.widget.GraphicsUtils;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import lombok.Generated;
import org.apache.commons.statistics.descriptive.DoubleStatistics;
import org.apache.commons.statistics.descriptive.Statistic;

public class RollingSuccessStatisticsWidget {
    private static final String DOUBLE_FORMAT = "%.2f";
    private final int width;
    private final int height;
    private final int padding;
    private final int windowSize;
    private final Theme theme;
    private final boolean opaque;
    private final List<SuccessResult> values = new ArrayList<SuccessResult>();
    private final String STD = "\u03c3";
    private final String SQR = "\u00b2";
    private BufferedImage cachedImage = null;

    public RollingSuccessStatisticsWidget(int width, int height, int padding, int windowSize, Theme theme, boolean opaque) {
        this.width = width;
        this.height = height;
        this.padding = padding;
        this.windowSize = windowSize;
        this.theme = theme;
        this.opaque = opaque;
    }

    public static RollingSuccessStatisticsWidgetBuilder builder() {
        return new RollingSuccessStatisticsWidgetBuilder();
    }

    public void addFailure() {
        this.addResult(false, 0.0);
    }

    public void addResult(boolean success, double value) {
        this.values.add(new SuccessResult(success, value));
        while (this.values.size() > this.windowSize) {
            this.values.removeFirst();
        }
        this.cachedImage = null;
    }

    public void addSuccess(double value) {
        this.addResult(true, value);
    }

    public BufferedImage getImage() {
        if (this.cachedImage == null) {
            this.cachedImage = this.renderStatistics();
        }
        return this.cachedImage;
    }

    public BufferedImage renderStatistics() {
        BufferedImage image;
        BufferedImage bufferedImage = image = this.opaque ? GraphicsUtils.createBlankImage(this.width, this.height, this.theme.getBackground()) : GraphicsUtils.createClearImage(this.width, this.height);
        if (!this.values.isEmpty()) {
            Graphics2D g = image.createGraphics();
            GraphicsUtils.setupRenderingHints(g);
            GraphicsUtils.drawCenteredText(g, 0, this.padding, this.width, 32, "Statistics", OutputConstants.STATISTICS_FONT, this.theme.getText());
            ArrayList<CallSite> lines = new ArrayList<CallSite>();
            double successRate = 100.0 * (double)this.values.stream().filter(SuccessResult::success).count() / (double)this.values.size();
            lines.add((CallSite)((Object)("Success rate: " + successRate + "%")));
            if (successRate > 0.0) {
                DoubleStatistics stats = DoubleStatistics.of(EnumSet.of(Statistic.MIN, Statistic.MAX, Statistic.MEAN, Statistic.VARIANCE, Statistic.STANDARD_DEVIATION), (double[])this.values.stream().filter(SuccessResult::success).mapToDouble(SuccessResult::value).toArray());
                lines.add((CallSite)((Object)("Minimum: " + String.format(DOUBLE_FORMAT, stats.getAsDouble(Statistic.MIN)))));
                lines.add((CallSite)((Object)("Maximum: " + String.format(DOUBLE_FORMAT, stats.getAsDouble(Statistic.MAX)))));
                lines.add((CallSite)((Object)("Mean: " + String.format(DOUBLE_FORMAT, stats.getAsDouble(Statistic.MEAN)))));
                lines.add((CallSite)((Object)("\u03c3: " + String.format(DOUBLE_FORMAT, stats.getAsDouble(Statistic.STANDARD_DEVIATION)))));
                lines.add((CallSite)((Object)("\u03c3\u00b2: " + String.format(DOUBLE_FORMAT, stats.getAsDouble(Statistic.VARIANCE)))));
            }
            int cursorY = 32 + (this.height - 32 * lines.size()) / 2;
            for (String string : lines) {
                GraphicsUtils.drawCenteredText(g, 0, cursorY, this.width, 32, string, OutputConstants.STATISTICS_FONT, this.theme.getText());
                cursorY += 32;
            }
        }
        return image;
    }

    public static class RollingSuccessStatisticsWidgetBuilder {
        private int width = 200;
        private int height = 200;
        private int padding = 40;
        private int windowSize = 200;
        private boolean opaque = true;
        private Theme theme = Theme.LIGHT;

        public RollingSuccessStatisticsWidget build() {
            return new RollingSuccessStatisticsWidget(this.width, this.height, this.padding, this.windowSize, this.theme, this.opaque);
        }

        @Generated
        public RollingSuccessStatisticsWidgetBuilder width(int width) {
            this.width = width;
            return this;
        }

        @Generated
        public RollingSuccessStatisticsWidgetBuilder height(int height) {
            this.height = height;
            return this;
        }

        @Generated
        public RollingSuccessStatisticsWidgetBuilder padding(int padding) {
            this.padding = padding;
            return this;
        }

        @Generated
        public RollingSuccessStatisticsWidgetBuilder windowSize(int windowSize) {
            this.windowSize = windowSize;
            return this;
        }

        @Generated
        public RollingSuccessStatisticsWidgetBuilder opaque(boolean opaque) {
            this.opaque = opaque;
            return this;
        }

        @Generated
        public RollingSuccessStatisticsWidgetBuilder theme(Theme theme) {
            this.theme = theme;
            return this;
        }
    }

    private record SuccessResult(boolean success, double value) {
    }
}

