/*
 * Decompiled with CFR 0.152.
 */
package dev.aisandbox.server.engine;

import dev.aisandbox.server.engine.Agent;
import dev.aisandbox.server.engine.Simulation;
import dev.aisandbox.server.engine.SimulationBuilder;
import dev.aisandbox.server.engine.SimulationRunner;
import dev.aisandbox.server.engine.Theme;
import dev.aisandbox.server.engine.exception.SimulationSetupException;
import dev.aisandbox.server.engine.network.NetworkAgent;
import dev.aisandbox.server.engine.output.OutputRenderer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;

public final class SimulationSetup {
    public static SimulationRunner setupSimulation(SimulationBuilder builder, int agentCount, int defaultPort, boolean openExternal, OutputRenderer renderer, Theme theme, long maxStepCount) throws SimulationSetupException {
        AtomicInteger port = new AtomicInteger(defaultPort);
        String[] agentNames = builder.getAgentNames(agentCount);
        ArrayList<Agent> agents = new ArrayList<Agent>();
        for (String agentName : agentNames) {
            agents.add(new NetworkAgent(agentName, port.getAndIncrement(), openExternal, renderer));
        }
        return SimulationSetup.setupSimulation(builder, agents, renderer, theme, maxStepCount);
    }

    public static SimulationRunner setupSimulation(SimulationBuilder builder, List<Agent> agents, OutputRenderer renderer, Theme theme, long maxStepCount) throws SimulationSetupException {
        Simulation sim = builder.build(agents, theme, new Random());
        renderer.setup(sim);
        return new SimulationRunner(sim, renderer, agents, maxStepCount);
    }

    @Generated
    private SimulationSetup() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

