/*
 * Decompiled with CFR 0.152.
 */
package dev.aisandbox.launcher;

import dev.aisandbox.launcher.options.RuntimeOptions;
import dev.aisandbox.launcher.options.RuntimeUtils;
import dev.aisandbox.server.engine.SimulationBuilder;
import dev.aisandbox.server.engine.SimulationParameter;
import dev.aisandbox.server.engine.SimulationRunner;
import dev.aisandbox.server.engine.SimulationSetup;
import dev.aisandbox.server.engine.Theme;
import dev.aisandbox.server.engine.exception.SimulationSetupException;
import dev.aisandbox.server.engine.output.BitmapOutputRenderer;
import dev.aisandbox.server.engine.output.NullOutputRenderer;
import dev.aisandbox.server.engine.output.OutputRenderer;
import dev.aisandbox.server.simulation.SimulationEnumeration;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.cli.HelpFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SandboxServerCLIApplication {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SandboxServerCLIApplication.class);
    private final List<SimulationBuilder> simulationBuilders = Arrays.stream(SimulationEnumeration.values()).map(SimulationEnumeration::getBuilder).toList();

    public void run(String ... args) {
        System.out.println("AISandbox Server CLI Application");
        System.out.println();
        RuntimeOptions runtimeOptions = RuntimeUtils.parseCommandLine(args);
        if (runtimeOptions.help()) {
            this.help(runtimeOptions);
        } else {
            this.runSimulation(runtimeOptions);
        }
    }

    private void help(RuntimeOptions runtimeOptions) {
        if (runtimeOptions.simulation() != null) {
            this.helpSimulation(runtimeOptions.simulation());
        } else {
            HelpFormatter formatter = new HelpFormatter();
            System.out.println();
            formatter.printHelp("AISandboxServer", RuntimeUtils.getOptions());
        }
    }

    private void runSimulation(RuntimeOptions options) {
        Optional<SimulationBuilder> oBuilder = this.simulationBuilders.stream().filter(simulationBuilder -> simulationBuilder.getSimulationName().equalsIgnoreCase(options.simulation())).findFirst();
        if (oBuilder.isEmpty()) {
            System.err.println("Can't find simulation with that name, use --help to show all simulations");
        } else {
            SimulationBuilder simulationBuilder2 = oBuilder.get();
            for (String parameter : options.parameters()) {
                String[] keyValue = parameter.split("[=:]");
                if (keyValue.length != 2) {
                    System.err.printf("Invalid parameter: '%s', use format key:value\n", parameter);
                    continue;
                }
                String key = keyValue[0];
                String value = keyValue[1];
                Optional<SimulationParameter> oParam = simulationBuilder2.getParameters().stream().filter(param -> param.name().equalsIgnoreCase(key)).findFirst();
                if (oParam.isPresent()) {
                    RuntimeUtils.setParameterValue(simulationBuilder2, oParam.get(), value);
                    continue;
                }
                System.err.printf("Can't set '%s' to '%s'%n\n", key, value);
            }
            int agents = simulationBuilder2.getMaxAgentCount();
            if (options.agents() >= simulationBuilder2.getMinAgentCount() && options.agents() <= simulationBuilder2.getMaxAgentCount()) {
                agents = options.agents();
            }
            OutputRenderer out = new NullOutputRenderer();
            if (options.outputImage()) {
                out = new BitmapOutputRenderer();
                out.setOutputDirectory(new File(options.outputDirectory()));
            }
            if (options.skip() > 0) {
                out.setSkipFrames(options.skip());
            }
            System.out.println("Running simulation '" + simulationBuilder2.getSimulationName() + "' with " + agents + " agents.");
            System.out.println("Output sent to " + out.getName());
            System.out.println("Listening on " + (String)(options.openExternal() ? " all interfaces" : "loopback interface starting on port " + options.startPort()));
            try {
                SimulationRunner runner = SimulationSetup.setupSimulation(simulationBuilder2, agents, options.startPort(), options.openExternal(), out, Theme.LIGHT, options.maxStepCount());
                runner.start();
            }
            catch (SimulationSetupException e) {
                log.error("Error setting up simulation", (Throwable)e);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void helpSimulation(String simulationName) {
        System.out.printf("Help for simulation %s\n\n", new Object[]{simulationName});
        oSim = this.findBuilder(simulationName);
        if (oSim.isPresent()) {
            sim = oSim.get();
            System.out.printf(" Minimum agents: %d\n", new Object[]{sim.getMinAgentCount()});
            System.out.printf(" Maximum agents: %d\n", new Object[]{sim.getMaxAgentCount()});
            try {
                parameters = sim.getParameters();
                if (parameters.isEmpty()) ** GOTO lbl27
                System.out.println("Options (use -o key:value to set)");
                for (SimulationParameter parameter : parameters) {
                    if (parameter.parameterType().isEnum()) {
                        System.out.printf(" %s (%s) - %s %s", new Object[]{parameter.name(), RuntimeUtils.getParameterValue(sim, parameter), parameter.description(), Arrays.toString(parameter.parameterType().getEnumConstants())});
                        continue;
                    }
                    System.out.printf(" %s (%s) - %s", new Object[]{parameter.name(), RuntimeUtils.getParameterValue(sim, parameter), parameter.description()});
                }
            }
            catch (Exception e) {
                SandboxServerCLIApplication.log.error("Error during describe simulation", (Throwable)e);
            }
        } else {
            System.out.println("Can't find simulation with that name");
        }
lbl27:
        // 4 sources

        System.out.println();
    }

    private Optional<SimulationBuilder> findBuilder(String name) {
        for (SimulationBuilder simulationBuilder : this.simulationBuilders) {
            if (!simulationBuilder.getSimulationName().equalsIgnoreCase(name)) continue;
            return Optional.of(simulationBuilder);
        }
        System.err.println("No simulation of that name exists, use the --help option to list all simulations");
        return Optional.empty();
    }

    private void listOptions(RuntimeOptions options) {
        if (options.simulation() == null) {
            System.out.println("Available simulations:");
            for (SimulationBuilder simulationBuilder : this.simulationBuilders) {
                if (simulationBuilder.getMinAgentCount() == simulationBuilder.getMaxAgentCount()) {
                    System.out.printf("%s (%d agents, %s)", simulationBuilder.getSimulationName(), simulationBuilder.getMinAgentCount(), simulationBuilder.getDescription());
                    continue;
                }
                System.out.printf("%s (%d-%d agents, %s)", simulationBuilder.getSimulationName(), simulationBuilder.getMinAgentCount(), simulationBuilder.getMaxAgentCount(), simulationBuilder.getDescription());
            }
        } else {
            this.helpSimulation(options.simulation());
        }
    }
}

