/*
 * Decompiled with CFR 0.152.
 */
package dev.aisandbox.server.fx;

import dev.aisandbox.server.engine.SimulationBuilder;
import dev.aisandbox.server.engine.SimulationRunner;
import dev.aisandbox.server.engine.SimulationSetup;
import dev.aisandbox.server.engine.Theme;
import dev.aisandbox.server.engine.exception.SimulationSetupException;
import dev.aisandbox.server.engine.output.FXRenderer;
import dev.aisandbox.server.fx.FXModel;
import dev.aisandbox.server.fx.WrappedImageView;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextArea;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RuntimeController.class);
    FXModel model = FXModel.INSTANCE.getInstance();
    String outputText = "";
    ImageView imageView;
    @FXML
    private ResourceBundle resources;
    @FXML
    private URL location;
    @FXML
    private TextArea logArea;
    @FXML
    private BorderPane borderPane;
    @FXML
    private Button stopSimulationButton;

    @FXML
    void stopSimulationAction(ActionEvent event) {
        Stage stage = (Stage)this.stopSimulationButton.getScene().getWindow();
        stage.close();
    }

    public void updateOutput(String line) {
        this.outputText = this.outputText + line + "\n";
        Platform.runLater(() -> this.logArea.setText(this.outputText));
    }

    public void updateImage(BufferedImage image) {
        WritableImage fximage = SwingFXUtils.toFXImage((BufferedImage)image, null);
        Platform.runLater(() -> this.lambda$updateImage$1((Image)fximage));
    }

    @FXML
    void initialize() {
        log.debug("Initializing RuntimeController");
        assert (this.logArea != null) : "fx:id=\"logArea\" was not injected: check your FXML file 'runtime.fxml'.";
        this.imageView = new ImageView(new Image(RuntimeController.class.getResourceAsStream("/images/backgrounds/testcard.png")));
        this.imageView.setPreserveRatio(true);
        this.borderPane.setCenter((Node)new WrappedImageView(this.imageView));
        try {
            FXRenderer renderer = new FXRenderer(this);
            SimulationRunner runner = SimulationSetup.setupSimulation((SimulationBuilder)this.model.getSelectedSimulationBuilder().get(), this.model.getAgentCount().get(), this.model.getDefaultPort().get(), this.model.getExternalNetwork().get(), renderer, (Theme)((Object)this.model.getSelectedTheme().get()), -1L);
            runner.start();
            this.model.setRunner(runner);
            log.debug("Initialized RuntimeController");
        }
        catch (SimulationSetupException e) {
            this.logArea.setText("Error initialising simulation.");
            log.error("Error setting up simulation", (Throwable)e);
        }
    }

    private /* synthetic */ void lambda$updateImage$1(Image fximage) {
        this.imageView.setImage(fximage);
    }
}

