/*
 * Decompiled with CFR 0.152.
 */
package dev.aisandbox.server.engine.widget;

import dev.aisandbox.server.engine.Theme;
import dev.aisandbox.server.engine.maths.BinContents;
import dev.aisandbox.server.engine.maths.bins.BinningEngine;
import dev.aisandbox.server.engine.maths.bins.EqualWidthBinner;
import dev.aisandbox.server.engine.widget.BaseGraph;
import dev.aisandbox.server.engine.widget.GraphicsUtils;
import dev.aisandbox.server.engine.widget.axis.NiceAxisScale;
import dev.aisandbox.server.engine.widget.axis.TightAxisScale;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class RollingValueHistogramWidget {
    private final int width;
    private final int height;
    private final int window;
    private final Theme theme;
    private final String title;
    private final String xAxisTitle;
    private final String yAxisTitle;
    private final BinningEngine binEngine;
    private final List<Double> values = new ArrayList<Double>();
    private BufferedImage image = null;

    public static RollingHistogramChartBuilder builder() {
        return new RollingHistogramChartBuilder();
    }

    public void addValue(double value) {
        this.values.add(value);
        while (this.values.size() > this.window) {
            this.values.removeFirst();
        }
        this.image = null;
    }

    public BufferedImage getImage() {
        if (this.image == null) {
            if (this.values.isEmpty()) {
                this.image = GraphicsUtils.createBlankImage(this.width, this.height, this.theme.getBackground());
            } else {
                List<BinContents> bins = this.binEngine.binValues(this.values);
                double maxValue = bins.stream().mapToDouble(value -> value.quantity()).max().orElse(1.0);
                TightAxisScale xAxis = new TightAxisScale(bins.getFirst().binStart(), bins.getLast().binEnd(), this.width / 40);
                NiceAxisScale yAxis = new NiceAxisScale(0.0, maxValue, 5);
                BaseGraph graph = new BaseGraph(this.width, this.height, this.title, this.xAxisTitle, this.yAxisTitle, this.theme, xAxis, yAxis);
                for (BinContents bin : bins) {
                    if (bin.quantity() <= 0) continue;
                    graph.addBox(bin.binStart(), 0.0, bin.binEnd(), bin.quantity(), this.theme.getPrimary(), this.theme.getPrimary());
                }
                graph.addAxisAndTitle();
                this.image = graph.getImage();
            }
        }
        return this.image;
    }

    @Generated
    public RollingValueHistogramWidget(int width, int height, int window, Theme theme, String title, String xAxisTitle, String yAxisTitle, BinningEngine binEngine) {
        this.width = width;
        this.height = height;
        this.window = window;
        this.theme = theme;
        this.title = title;
        this.xAxisTitle = xAxisTitle;
        this.yAxisTitle = yAxisTitle;
        this.binEngine = binEngine;
    }

    public static class RollingHistogramChartBuilder {
        private int width = 200;
        private int height = 200;
        private int window = 200;
        private Theme theme = Theme.LIGHT;
        private String title = "Histogram Title";
        private String xAxisTitle = "Score";
        private String yAxisTitle = "Frequency";
        private BinningEngine binEngine = new EqualWidthBinner();

        public RollingValueHistogramWidget build() {
            return new RollingValueHistogramWidget(this.width, this.height, this.window, this.theme, this.title, this.xAxisTitle, this.yAxisTitle, this.binEngine);
        }

        @Generated
        public RollingHistogramChartBuilder width(int width) {
            this.width = width;
            return this;
        }

        @Generated
        public RollingHistogramChartBuilder height(int height) {
            this.height = height;
            return this;
        }

        @Generated
        public RollingHistogramChartBuilder window(int window) {
            this.window = window;
            return this;
        }

        @Generated
        public RollingHistogramChartBuilder theme(Theme theme) {
            this.theme = theme;
            return this;
        }

        @Generated
        public RollingHistogramChartBuilder title(String title) {
            this.title = title;
            return this;
        }

        @Generated
        public RollingHistogramChartBuilder xAxisTitle(String xAxisTitle) {
            this.xAxisTitle = xAxisTitle;
            return this;
        }

        @Generated
        public RollingHistogramChartBuilder yAxisTitle(String yAxisTitle) {
            this.yAxisTitle = yAxisTitle;
            return this;
        }

        @Generated
        public RollingHistogramChartBuilder binEngine(BinningEngine binEngine) {
            this.binEngine = binEngine;
            return this;
        }
    }
}

