/*
 * Decompiled with CFR 0.152.
 */
package dev.aisandbox.server.simulation.twisty;

import dev.aisandbox.server.engine.output.OutputConstants;
import dev.aisandbox.server.engine.output.SpriteLoader;
import dev.aisandbox.server.engine.widget.GraphicsUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuboidMoveIconBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CuboidMoveIconBuilder.class);
    static final int marginLeft = 10;
    static final int marginRight = 10;
    static final int marginTop = 10;
    static final int marginBottom = 10;
    static final Color UNFILLED = Color.lightGray;
    static final Color FILLED = Color.darkGray;
    static final Color LINES = Color.BLACK;
    static final List<BufferedImage> arrows = SpriteLoader.loadSpritesFromResources("/images/twisty/CuboidArrows.png", 60, 60);
    final int width;
    final int height;
    final int originX;
    final double scale;
    BufferedImage backgroundImage = GraphicsUtils.createBlankImage(60, 85, Color.WHITE);
    BufferedImage middleImage = GraphicsUtils.createClearImage(60, 85);
    BufferedImage foregroundImage = GraphicsUtils.createClearImage(60, 85);
    Graphics2D backgroundGraphics = this.backgroundImage.createGraphics();
    Graphics2D middleGraphics = this.middleImage.createGraphics();
    Graphics2D foregroundGraphics = this.foregroundImage.createGraphics();

    public CuboidMoveIconBuilder(int width, int height, String name) {
        this.width = width;
        this.height = height;
        GraphicsUtils.setupRenderingHints(this.foregroundGraphics);
        double horizontalScale = 40.0 / (1.0 * (double)width);
        double verticalScale = 65.0 / (1.0 * (double)height);
        this.scale = Math.min(horizontalScale, verticalScale);
        this.originX = 10 + (int)((40.0 - (double)width * this.scale) / 2.0);
        this.drawCuboid(this.originX, 10, width, height, this.scale);
        CuboidMoveIconBuilder.drawName(this.foregroundGraphics, name);
    }

    private void drawCuboid(int originX, int originY, int width, int height, double scale) {
        int i;
        this.middleGraphics.setColor(UNFILLED);
        this.middleGraphics.fillRect(originX, originY, (int)((double)width * scale), (int)((double)height * scale));
        this.foregroundGraphics.setColor(LINES);
        for (i = 0; i <= width; ++i) {
            this.foregroundGraphics.drawLine((int)((double)originX + (double)i * scale), originY, (int)((double)originX + (double)i * scale), (int)((double)originY + (double)height * scale));
        }
        for (i = 0; i <= height; ++i) {
            this.foregroundGraphics.drawLine(originX, originY + (int)((double)i * scale), originX + (int)((double)width * scale), originY + (int)((double)i * scale));
        }
    }

    private static void drawName(Graphics2D g, String name) {
        GraphicsUtils.drawCenteredText(g, 0, 59, 60, 16, name, OutputConstants.LOG_FONT, Color.BLACK);
    }

    public static CuboidMoveIconBuilder builer(int width, int height, String name) {
        return new CuboidMoveIconBuilder(width, height, name);
    }

    public CuboidMoveIconBuilder fillFrontFace() {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                this.fillFrontFace(x, y);
            }
        }
        return this;
    }

    private void fillFrontFace(int x, int y) {
        this.fillFrontFace(x, y, FILLED);
    }

    private void fillFrontFace(int x, int y, Color color) {
        this.middleGraphics.setColor(color);
        this.middleGraphics.fillRect((int)((double)this.originX + (double)x * this.scale), (int)(10.0 + this.scale * (double)y), (int)this.scale + 1, (int)this.scale + 1);
    }

    public CuboidMoveIconBuilder fillFromTop(int n) {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < n; ++y) {
                this.fillFrontFace(x, y);
            }
        }
        return this;
    }

    public CuboidMoveIconBuilder fillFromBottom(int n) {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < n; ++y) {
                this.fillFrontFace(x, this.height - y - 1);
            }
        }
        return this;
    }

    public CuboidMoveIconBuilder fillFromLeft(int n) {
        for (int x = 0; x < n; ++x) {
            for (int y = 0; y < this.height; ++y) {
                this.fillFrontFace(x, y);
            }
        }
        return this;
    }

    public CuboidMoveIconBuilder fillFromRight(int n) {
        for (int x = 0; x < n; ++x) {
            for (int y = 0; y < this.height; ++y) {
                this.fillFrontFace(this.width - x - 1, y);
            }
        }
        return this;
    }

    public CuboidMoveIconBuilder setRotation(char face, boolean inverse) {
        switch (face) {
            case 'F': {
                this.foregroundGraphics.drawImage((Image)arrows.get(inverse ? 5 : 0), 0, 0, null);
                break;
            }
            case 'B': {
                this.backgroundGraphics.drawImage((Image)arrows.get(inverse ? 0 : 5), 0, 0, null);
                break;
            }
            case 'U': {
                this.foregroundGraphics.drawImage((Image)arrows.get(inverse ? 6 : 1), 0, 0, null);
                break;
            }
            case 'D': {
                this.foregroundGraphics.drawImage((Image)arrows.get(inverse ? 7 : 2), 0, 0, null);
                break;
            }
            case 'R': {
                this.foregroundGraphics.drawImage((Image)arrows.get(inverse ? 8 : 3), 0, 0, null);
                break;
            }
            case 'L': {
                this.foregroundGraphics.drawImage((Image)arrows.get(inverse ? 9 : 4), 0, 0, null);
                break;
            }
            default: {
                log.warn("Unknown face: {}", (Object)Character.valueOf(face));
            }
        }
        return this;
    }

    public BufferedImage getImage() {
        BufferedImage image = new BufferedImage(60, 85, 1);
        Graphics2D g = image.createGraphics();
        g.drawImage((Image)this.backgroundImage, 0, 0, null);
        g.drawImage((Image)this.middleImage, 0, 0, null);
        g.drawImage((Image)this.foregroundImage, 0, 0, null);
        return image;
    }
}

