/*
 * Decompiled with CFR 0.152.
 */
package dev.aisandbox.server.fx;

import dev.aisandbox.launcher.options.RuntimeUtils;
import dev.aisandbox.server.engine.SimulationBuilder;
import dev.aisandbox.server.engine.SimulationParameter;
import dev.aisandbox.server.engine.Theme;
import dev.aisandbox.server.fx.FXModel;
import dev.aisandbox.server.fx.SimulationBuilderRenderer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.TreeMap;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.TextArea;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.stage.Window;
import javafx.util.Callback;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetupController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SetupController.class);
    FXModel model = FXModel.INSTANCE.getInstance();
    @FXML
    private VBox parameterBox;
    @FXML
    private TextArea simDescription;
    @FXML
    private Spinner<Integer> agentCounter;
    @FXML
    private ChoiceBox<Theme> themeChoice;
    @FXML
    private CheckBox externalCheckBox;
    @FXML
    private ListView<SimulationBuilder> simulationList;

    @FXML
    void initialize() {
        assert (this.agentCounter != null) : "fx:id=\"agentCounter\" was not injected: check your FXML file 'simulation.fxml'.";
        assert (this.externalCheckBox != null) : "fx:id=\"externalCheckBox\" was not injected: check your FXML file 'simulation.fxml'.";
        assert (this.parameterBox != null) : "fx:id=\"parameterBox\" was not injected: check your FXML file 'simulation.fxml'.";
        assert (this.simDescription != null) : "fx:id=\"simDescription\" was not injected: check your FXML file 'simulation.fxml'.";
        assert (this.simulationList != null) : "fx:id=\"simulationList\" was not injected: check your FXML file 'simulation.fxml'.";
        assert (this.themeChoice != null) : "fx:id=\"themeChoice\" was not injected: check your FXML file 'simulation.fxml'.";
        this.simulationList.setItems(this.model.getSimulations());
        this.simulationList.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.model.getSelectedSimulationBuilder().bind((ObservableValue)this.simulationList.getSelectionModel().selectedItemProperty());
        this.agentCounter.setDisable(true);
        this.agentCounter.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.IntegerSpinnerValueFactory(1, 1, 1));
        this.simulationList.setCellFactory((Callback)new SimulationBuilderRenderer());
        this.simulationList.getSelectionModel().selectedItemProperty().addListener((observableValue, oldValue, newValue) -> {
            if (newValue != null) {
                this.simDescription.setText(newValue.getDescription());
                this.model.getAgentCount().unbind();
                this.agentCounter.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.IntegerSpinnerValueFactory(newValue.getMinAgentCount(), newValue.getMaxAgentCount(), this.getValueInRange((Integer)this.agentCounter.getValue(), newValue.getMinAgentCount(), newValue.getMaxAgentCount())));
                this.agentCounter.setDisable(false);
                this.model.getAgentCount().bind((ObservableValue)this.agentCounter.valueProperty());
                this.parameterBox.getChildren().clear();
                for (SimulationParameter parameter : newValue.getParameters()) {
                    this.parameterBox.getChildren().add((Object)SetupController.createParameterEditor(newValue, parameter));
                }
            } else {
                this.simDescription.setText("");
                this.model.getAgentCount().unbind();
                this.agentCounter.setDisable(true);
                this.parameterBox.getChildren().clear();
            }
        });
        this.simulationList.getSelectionModel().select(0);
        this.themeChoice.getItems().addAll((Object[])Theme.values());
        this.model.getSelectedTheme().bind((ObservableValue)this.themeChoice.valueProperty());
        this.themeChoice.getSelectionModel().select((Object)Theme.LIGHT);
        this.model.getExternalNetwork().bind((ObservableValue)this.externalCheckBox.selectedProperty());
    }

    private int getValueInRange(int value, int min, int max) {
        return Math.min(max, Math.max(min, value));
    }

    public static Node createParameterEditor(SimulationBuilder builder, SimulationParameter parameter) {
        BorderPane node = new BorderPane();
        Label label = new Label(parameter.name());
        label.setMaxWidth(Double.MAX_VALUE);
        label.setAlignment(Pos.CENTER_LEFT);
        node.setCenter((Node)label);
        if (parameter.parameterType().isEnum()) {
            TreeMap enumMap = new TreeMap();
            ArrayList enumList = new ArrayList();
            Arrays.stream(parameter.parameterType().getEnumConstants()).forEach(o -> {
                enumMap.put(o.toString(), ((Enum)o).name());
                enumList.add(o.toString());
            });
            ComboBox editor = new ComboBox();
            editor.setItems(FXCollections.observableList(enumList));
            editor.getSelectionModel().select((Object)RuntimeUtils.getParameterValue(builder, parameter));
            editor.valueProperty().addListener((observable, oldValue, newValue) -> RuntimeUtils.setParameterValue(builder, parameter, (String)enumMap.get(newValue)));
            node.setRight((Node)editor);
        } else if (parameter.parameterType() == Boolean.class) {
            CheckBox editor = new CheckBox();
            editor.setSelected(RuntimeUtils.getParameterValue(builder, parameter).equalsIgnoreCase("true"));
            editor.selectedProperty().addListener((observable, oldValue, newValue) -> RuntimeUtils.setParameterValue(builder, parameter, newValue != false ? "true" : "false"));
            node.setRight((Node)editor);
        } else {
            log.error("Dont know how to build an editor for {}", (Object)parameter.parameterType().getName());
        }
        Tooltip tooltip = new Tooltip(parameter.description());
        Tooltip.install((Node)node, (Tooltip)tooltip);
        return node;
    }

    @FXML
    void startSimulation(ActionEvent event) {
        if (this.model.getSelectedSimulationBuilder().get() != null) {
            try {
                FXMLLoader loader = new FXMLLoader(SetupController.class.getResource("/fx/runtime.fxml"));
                loader.setResources(ResourceBundle.getBundle("fx.runtime"));
                Parent root = (Parent)loader.load();
                Window window = ((Button)event.getSource()).getScene().getWindow();
                window.getScene().setRoot(root);
            }
            catch (IOException e) {
                log.error("Error switching Javafx scenes", (Throwable)e);
            }
        }
    }
}

