/*
 * Decompiled with CFR 0.152.
 */
package dev.aisandbox.server.engine.output;

import dev.aisandbox.server.engine.Simulation;
import dev.aisandbox.server.engine.output.OutputRenderer;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitmapOutputRenderer
implements OutputRenderer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BitmapOutputRenderer.class);
    private Simulation simulation;
    private long imageCounter = 0L;
    private File outputDirectory = new File("./");
    private int skipframes = -1;

    @Override
    public String getName() {
        return "PNG file";
    }

    @Override
    public void setup(Simulation simulation) {
        this.simulation = simulation;
    }

    @Override
    public void setSkipFrames(int framesToSkip) {
        if (framesToSkip > 0) {
            this.skipframes = framesToSkip;
        }
    }

    @Override
    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @Override
    public void display() {
        if (this.skipframes == 0 || this.imageCounter % (long)this.skipframes == 0L) {
            try {
                BufferedImage image = new BufferedImage(1920, 1080, 1);
                Graphics2D g2d = image.createGraphics();
                this.simulation.visualise(g2d);
                ImageIO.write((RenderedImage)image, "png", new File(this.outputDirectory, this.imageCounter + ".png"));
            }
            catch (IOException e) {
                log.error("Error writing image to file", (Throwable)e);
            }
        }
        ++this.imageCounter;
    }

    @Override
    public void write(String text) {
        System.out.println(text);
    }

    @Generated
    public BitmapOutputRenderer() {
    }
}

