/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.descriptive;

import org.apache.commons.statistics.descriptive.Int128;
import org.apache.commons.statistics.descriptive.IntMath;
import org.apache.commons.statistics.descriptive.LongStatistic;
import org.apache.commons.statistics.descriptive.StatisticAccumulator;

public final class LongMean
implements LongStatistic,
StatisticAccumulator<LongMean> {
    private static final long SMALL_SUM = 0x20000000000000L;
    private final Int128 sum;
    private long n;

    private LongMean() {
        this(Int128.create(), 0);
    }

    private LongMean(Int128 sum, int n) {
        this.sum = sum;
        this.n = n;
    }

    public static LongMean create() {
        return new LongMean();
    }

    public static LongMean of(long ... values) {
        Int128 s = Int128.create();
        for (long x : values) {
            s.add(x);
        }
        return new LongMean(s, values.length);
    }

    @Override
    public void accept(long value) {
        this.sum.add(value);
        ++this.n;
    }

    @Override
    public double getAsDouble() {
        return LongMean.computeMean(this.sum, this.n);
    }

    static double computeMean(Int128 sum, long n) {
        if (sum.hi64() == 0L && Math.abs(sum.lo64()) < 0x20000000000000L) {
            return (double)sum.lo64() / (double)n;
        }
        return IntMath.divide(sum, n);
    }

    @Override
    public LongMean combine(LongMean other) {
        this.sum.add(other.sum);
        this.n += other.n;
        return this;
    }
}

