/*
 * Decompiled with CFR 0.152.
 */
package dev.aisandbox.server.simulation.twisty.model;

import dev.aisandbox.server.simulation.twisty.model.Cell;
import dev.aisandbox.server.simulation.twisty.model.CompiledMove;
import dev.aisandbox.server.simulation.twisty.model.MoveLoop;
import dev.aisandbox.server.simulation.twisty.model.TwistyPuzzle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Move {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Move.class);
    public static final int MOVE_ICON_WIDTH = 60;
    public static final int MOVE_ICON_HEIGHT = 85;
    String name;
    List<MoveLoop> loops = new ArrayList<MoveLoop>();
    int cost;
    private BufferedImage imageIcon = new BufferedImage(60, 85, 1);

    public String toString() {
        return this.name + " (" + this.loops.size() + ")";
    }

    protected CompiledMove compileMove(TwistyPuzzle puzzle) {
        List<Cell> cells = puzzle.getCells();
        CompiledMove cmove = new CompiledMove(cells.size());
        cmove.setImage(this.imageIcon);
        cmove.setCost(this.cost);
        cmove.resetMove();
        if (this.loops.isEmpty()) {
            log.warn("No loops found in move {}", (Object)this.name);
            throw new IllegalArgumentException("No loops found in move " + this.name);
        }
        for (MoveLoop loop : this.loops) {
            if (loop.getCells().size() < 2) {
                log.warn("Loop {} has less than two cells", (Object)loop);
                continue;
            }
            for (int j = 0; j < loop.getCells().size() - 1; ++j) {
                cmove.setMatrixElement(cells.indexOf(loop.getCells().get(j + 1)), cells.indexOf(loop.getCells().get(j)));
            }
            cmove.setMatrixElement(cells.indexOf(loop.getCells().getFirst()), cells.indexOf(loop.getCells().getLast()));
        }
        return cmove;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public List<MoveLoop> getLoops() {
        return this.loops;
    }

    @Generated
    public void setCost(int cost) {
        this.cost = cost;
    }

    @Generated
    public int getCost() {
        return this.cost;
    }

    @Generated
    public void setImageIcon(BufferedImage imageIcon) {
        this.imageIcon = imageIcon;
    }

    @Generated
    public BufferedImage getImageIcon() {
        return this.imageIcon;
    }
}

