/*
 * Decompiled with CFR 0.152.
 */
package dev.aisandbox.server.simulation.twisty;

import dev.aisandbox.server.simulation.twisty.CuboidMoveIconBuilder;
import dev.aisandbox.server.simulation.twisty.model.Cell;
import dev.aisandbox.server.simulation.twisty.model.ColourEnum;
import dev.aisandbox.server.simulation.twisty.model.Move;
import dev.aisandbox.server.simulation.twisty.model.MoveLoop;
import dev.aisandbox.server.simulation.twisty.model.TwistyPuzzle;
import dev.aisandbox.server.simulation.twisty.model.shapes.ShapeEnum;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CuboidBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CuboidBuilder.class);
    private static final int gap = 4;

    public static TwistyPuzzle buildCuboid(int width, int height, int depth) throws IOException {
        int layer;
        int layer2;
        TwistyPuzzle puzzle = new TwistyPuzzle();
        puzzle.setPuzzleName((width == height && height == depth ? "Cube " : "Cuboid ") + width + "x" + height + "x" + depth);
        int vscale = 872 / ((height + depth * 2) * 2);
        int hscale = 1161 / ((width * 2 + depth * 2) * 2);
        int scale = Math.min(vscale, hscale);
        log.info("Calculating sides of cuboid {}x{}x{} with scale {}", new Object[]{width, height, depth, scale});
        ArrayList<Cell> top = new ArrayList<Cell>(CuboidBuilder.createGrid(0, 0, width, depth, ColourEnum.WHITE, scale));
        ArrayList<Cell> left = new ArrayList<Cell>(CuboidBuilder.createGrid(-depth * scale * 2 - 4, depth * scale * 2 + 4, depth, height, ColourEnum.ORANGE, scale));
        ArrayList<Cell> front = new ArrayList<Cell>(CuboidBuilder.createGrid(0, depth * scale * 2 + 4, width, height, ColourEnum.GREEN, scale));
        ArrayList<Cell> right = new ArrayList<Cell>(CuboidBuilder.createGrid(width * scale * 2 + 4, depth * scale * 2 + 4, depth, height, ColourEnum.RED, scale));
        ArrayList<Cell> back = new ArrayList<Cell>(CuboidBuilder.createGrid((width + depth) * scale * 2 + 8, depth * scale * 2 + 4, width, height, ColourEnum.BLUE, scale));
        ArrayList<Cell> bottom = new ArrayList<Cell>(CuboidBuilder.createGrid(0, (depth + height) * scale * 2 + 8, width, depth, ColourEnum.YELLOW, scale));
        puzzle.getCells().addAll(top);
        puzzle.getFaceSizes().add(top.size());
        puzzle.getCells().addAll(left);
        puzzle.getFaceSizes().add(left.size());
        puzzle.getCells().addAll(front);
        puzzle.getFaceSizes().add(front.size());
        puzzle.getCells().addAll(right);
        puzzle.getFaceSizes().add(right.size());
        puzzle.getCells().addAll(back);
        puzzle.getFaceSizes().add(back.size());
        puzzle.getCells().addAll(bottom);
        puzzle.getFaceSizes().add(bottom.size());
        if (width == height) {
            for (int deep = 1; deep < depth; ++deep) {
                log.info("Generating F at depth {}", (Object)deep);
                Move frontMove = new Move();
                frontMove.setName(CuboidBuilder.getMoveName(deep, 'F', 1));
                frontMove.setImageIcon(CuboidMoveIconBuilder.builer(width, height, frontMove.getName()).fillFrontFace().setRotation('F', false).getImage());
                frontMove.getLoops().addAll(CuboidBuilder.faceTurn(front, width, height));
                for (int layer3 = 1; layer3 <= deep; ++layer3) {
                    frontMove.getLoops().addAll(CuboidBuilder.frontSideTurn(layer3, width, height, depth, left, right, top, bottom));
                }
                frontMove.setCost(1);
                puzzle.addMove(frontMove);
                log.info("Generating F' at depth {}", (Object)deep);
                Move frontPrimeMove = new Move();
                frontPrimeMove.setName(CuboidBuilder.getMoveName(deep, 'F', -1));
                frontPrimeMove.setImageIcon(CuboidMoveIconBuilder.builer(width, height, frontPrimeMove.getName()).fillFrontFace().setRotation('F', true).getImage());
                frontPrimeMove.getLoops().addAll(CuboidBuilder.faceReverseTurn(front, width, height));
                for (int layer4 = 1; layer4 <= deep; ++layer4) {
                    frontPrimeMove.getLoops().addAll(CuboidBuilder.frontSideReverseTurn(layer4, width, height, depth, left, right, top, bottom));
                }
                frontPrimeMove.setCost(1);
                puzzle.addMove(frontPrimeMove);
                log.info("Generating B at depth {}", (Object)deep);
                Move backMove = new Move();
                backMove.setName(CuboidBuilder.getMoveName(deep, 'B', 1));
                backMove.setImageIcon(CuboidMoveIconBuilder.builer(width, height, backMove.getName()).setRotation('B', false).getImage());
                backMove.getLoops().addAll(CuboidBuilder.faceTurn(back, width, height));
                for (int layer5 = 1; layer5 <= deep; ++layer5) {
                    backMove.getLoops().addAll(CuboidBuilder.frontSideReverseTurn(depth - layer5 + 1, width, height, depth, left, right, top, bottom));
                }
                backMove.setCost(1);
                puzzle.addMove(backMove);
                log.info("Generating B' at depth {}", (Object)deep);
                Move backPrimeMove = new Move();
                backPrimeMove.setName(CuboidBuilder.getMoveName(deep, 'B', -1));
                backPrimeMove.setImageIcon(CuboidMoveIconBuilder.builer(width, height, backPrimeMove.getName()).setRotation('B', true).getImage());
                backPrimeMove.getLoops().addAll(CuboidBuilder.faceReverseTurn(back, width, height));
                for (layer2 = 1; layer2 <= deep; ++layer2) {
                    backPrimeMove.getLoops().addAll(CuboidBuilder.frontSideTurn(depth - layer2 + 1, width, height, depth, left, right, top, bottom));
                }
                backPrimeMove.setCost(1);
                puzzle.addMove(backPrimeMove);
            }
            log.info("Generating Z");
            Move frontRotationMove = new Move();
            frontRotationMove.setName(CuboidBuilder.getMoveName(0, 'F', 1));
            frontRotationMove.setImageIcon(CuboidMoveIconBuilder.builer(width, height, frontRotationMove.getName()).fillFrontFace().setRotation('F', false).getImage());
            frontRotationMove.getLoops().addAll(CuboidBuilder.faceTurn(front, width, height));
            frontRotationMove.getLoops().addAll(CuboidBuilder.faceReverseTurn(back, width, height));
            for (int layer6 = 1; layer6 <= depth; ++layer6) {
                frontRotationMove.getLoops().addAll(CuboidBuilder.frontSideTurn(layer6, width, height, depth, left, right, top, bottom));
            }
            frontRotationMove.setCost(0);
            puzzle.addMove(frontRotationMove);
            log.info("Generating Z'");
            Move frontRotationPrimeMove = new Move();
            frontRotationPrimeMove.setName(CuboidBuilder.getMoveName(0, 'F', -1));
            frontRotationPrimeMove.setImageIcon(CuboidMoveIconBuilder.builer(width, height, frontRotationPrimeMove.getName()).fillFrontFace().setRotation('F', true).getImage());
            frontRotationPrimeMove.getLoops().addAll(CuboidBuilder.faceReverseTurn(front, width, height));
            frontRotationPrimeMove.getLoops().addAll(CuboidBuilder.faceTurn(back, width, height));
            for (layer = 1; layer <= depth; ++layer) {
                frontRotationPrimeMove.getLoops().addAll(CuboidBuilder.frontSideReverseTurn(layer, width, height, depth, left, right, top, bottom));
            }
            frontRotationPrimeMove.setCost(0);
            puzzle.addMove(frontRotationPrimeMove);
        }
        if (width == depth) {
            for (int deep = 1; deep < height; ++deep) {
                log.info("Generating U to depth {}", (Object)deep);
                Move upMove = new Move();
                upMove.setName(CuboidBuilder.getMoveName(deep, 'U', 1));
                upMove.setImageIcon(CuboidMoveIconBuilder.builer(width, height, upMove.getName()).fillFromTop(deep).setRotation('U', false).getImage());
                upMove.getLoops().addAll(CuboidBuilder.faceTurn(top, width, depth));
                for (int layer7 = 1; layer7 <= deep; ++layer7) {
                    upMove.getLoops().addAll(CuboidBuilder.topSideTurn(layer7, width, height, depth, left, right, front, back));
                }
                upMove.setCost(1);
                puzzle.addMove(upMove);
                log.info("Generating U' to depth {}", (Object)deep);
                Move upPrimeMove = new Move();
                upPrimeMove.setName(CuboidBuilder.getMoveName(deep, 'U', -1));
                upPrimeMove.setImageIcon(CuboidMoveIconBuilder.builer(width, height, upPrimeMove.getName()).fillFromTop(deep).setRotation('U', true).getImage());
                upPrimeMove.getLoops().addAll(CuboidBuilder.faceReverseTurn(top, width, depth));
                for (int layer8 = 1; layer8 <= deep; ++layer8) {
                    upPrimeMove.getLoops().addAll(CuboidBuilder.topSideReverseTurn(layer8, width, height, depth, left, right, front, back));
                }
                upPrimeMove.setCost(0);
                puzzle.addMove(upPrimeMove);
                log.info("Generating D to depth {}", (Object)deep);
                Move downMove = new Move();
                downMove.setName(CuboidBuilder.getMoveName(deep, 'D', 1));
                downMove.setImageIcon(CuboidMoveIconBuilder.builer(width, height, downMove.getName()).fillFromBottom(deep).setRotation('D', false).getImage());
                downMove.getLoops().addAll(CuboidBuilder.faceTurn(bottom, width, depth));
                for (int layer9 = 1; layer9 <= deep; ++layer9) {
                    downMove.getLoops().addAll(CuboidBuilder.topSideReverseTurn(height - layer9 + 1, width, height, depth, left, right, front, back));
                }
                downMove.setCost(1);
                puzzle.addMove(downMove);
                log.info("Generating D' to depth {}", (Object)deep);
                Move downPrimeMove = new Move();
                downPrimeMove.setName(CuboidBuilder.getMoveName(deep, 'D', -1));
                downPrimeMove.setImageIcon(CuboidMoveIconBuilder.builer(width, height, downPrimeMove.getName()).fillFromBottom(deep).setRotation('D', true).getImage());
                downPrimeMove.getLoops().addAll(CuboidBuilder.faceReverseTurn(bottom, width, depth));
                for (layer2 = 1; layer2 <= deep; ++layer2) {
                    downPrimeMove.getLoops().addAll(CuboidBuilder.topSideTurn(height - layer2 + 1, width, height, depth, left, right, front, back));
                }
                downPrimeMove.setCost(1);
                puzzle.addMove(downPrimeMove);
            }
            Move topRotationMove = new Move();
            log.info("Generating y");
            topRotationMove.setName(CuboidBuilder.getMoveName(0, 'U', 1));
            topRotationMove.setImageIcon(CuboidMoveIconBuilder.builer(width, height, topRotationMove.getName()).fillFrontFace().setRotation('U', false).getImage());
            topRotationMove.getLoops().addAll(CuboidBuilder.faceTurn(top, width, depth));
            topRotationMove.getLoops().addAll(CuboidBuilder.faceReverseTurn(bottom, width, depth));
            for (int layer10 = 1; layer10 <= height; ++layer10) {
                topRotationMove.getLoops().addAll(CuboidBuilder.topSideTurn(layer10, width, height, depth, left, right, front, back));
            }
            topRotationMove.setCost(0);
            puzzle.addMove(topRotationMove);
            log.info("Generating y'");
            Move topRotationPriveMove = new Move();
            topRotationPriveMove.setName(CuboidBuilder.getMoveName(0, 'U', -1));
            topRotationPriveMove.setImageIcon(CuboidMoveIconBuilder.builer(width, height, topRotationPriveMove.getName()).fillFrontFace().setRotation('U', true).getImage());
            topRotationPriveMove.getLoops().addAll(CuboidBuilder.faceReverseTurn(top, width, depth));
            topRotationPriveMove.getLoops().addAll(CuboidBuilder.faceTurn(bottom, width, depth));
            for (layer = 1; layer <= height; ++layer) {
                topRotationPriveMove.getLoops().addAll(CuboidBuilder.topSideReverseTurn(layer, width, height, depth, left, right, front, back));
            }
            topRotationPriveMove.setCost(0);
            puzzle.addMove(topRotationPriveMove);
        }
        if (depth == height) {
            for (int deep = 1; deep < width; ++deep) {
                log.info("Generating R to depth {}", (Object)deep);
                Move rightMove = new Move();
                rightMove.setName(CuboidBuilder.getMoveName(deep, 'R', 1));
                rightMove.setImageIcon(CuboidMoveIconBuilder.builer(width, height, rightMove.getName()).fillFromRight(deep).setRotation('R', false).getImage());
                rightMove.getLoops().addAll(CuboidBuilder.faceTurn(right, depth, height));
                for (int layer11 = 1; layer11 <= deep; ++layer11) {
                    rightMove.getLoops().addAll(CuboidBuilder.rightSideTurn(layer11, width, height, depth, front, back, top, bottom));
                }
                rightMove.setCost(1);
                puzzle.addMove(rightMove);
                log.info("Generating R' to depth {}", (Object)deep);
                Move rightPrimeMove = new Move();
                rightPrimeMove.setName(CuboidBuilder.getMoveName(deep, 'R', -1));
                rightPrimeMove.setImageIcon(CuboidMoveIconBuilder.builer(width, height, rightPrimeMove.getName()).fillFromRight(deep).setRotation('R', true).getImage());
                rightPrimeMove.getLoops().addAll(CuboidBuilder.faceReverseTurn(right, depth, height));
                for (int layer12 = 1; layer12 <= deep; ++layer12) {
                    rightPrimeMove.getLoops().addAll(CuboidBuilder.rightSideReverseTurn(layer12, width, height, depth, front, back, top, bottom));
                }
                rightPrimeMove.setCost(1);
                puzzle.addMove(rightPrimeMove);
                log.info("Generating L to depth {}", (Object)deep);
                Move leftMove = new Move();
                leftMove.setName(CuboidBuilder.getMoveName(deep, 'L', 1));
                leftMove.setImageIcon(CuboidMoveIconBuilder.builer(width, height, leftMove.getName()).fillFromLeft(deep).setRotation('L', false).getImage());
                leftMove.getLoops().addAll(CuboidBuilder.faceTurn(left, depth, height));
                for (int layer13 = 1; layer13 <= deep; ++layer13) {
                    leftMove.getLoops().addAll(CuboidBuilder.rightSideReverseTurn(width - layer13 + 1, width, height, depth, front, back, top, bottom));
                }
                leftMove.setCost(1);
                puzzle.addMove(leftMove);
                log.info("Generating L' to depth {}", (Object)deep);
                Move leftPrimeMove = new Move();
                leftPrimeMove.setName(CuboidBuilder.getMoveName(deep, 'L', -1));
                leftPrimeMove.setImageIcon(CuboidMoveIconBuilder.builer(width, height, leftPrimeMove.getName()).fillFromLeft(deep).setRotation('L', true).getImage());
                leftPrimeMove.getLoops().addAll(CuboidBuilder.faceReverseTurn(left, depth, height));
                for (layer2 = 1; layer2 <= deep; ++layer2) {
                    leftPrimeMove.getLoops().addAll(CuboidBuilder.rightSideTurn(width - layer2 + 1, width, height, depth, front, back, top, bottom));
                }
                leftPrimeMove.setCost(1);
                puzzle.addMove(leftPrimeMove);
            }
            log.info("Generating x");
            Move rightRotationMove = new Move();
            rightRotationMove.setName(CuboidBuilder.getMoveName(0, 'R', 1));
            rightRotationMove.setImageIcon(CuboidMoveIconBuilder.builer(width, height, rightRotationMove.getName()).fillFrontFace().setRotation('R', false).getImage());
            rightRotationMove.getLoops().addAll(CuboidBuilder.faceTurn(right, depth, height));
            rightRotationMove.getLoops().addAll(CuboidBuilder.faceReverseTurn(left, depth, height));
            for (int layer14 = 1; layer14 <= width; ++layer14) {
                rightRotationMove.getLoops().addAll(CuboidBuilder.rightSideTurn(layer14, width, height, depth, front, back, top, bottom));
            }
            rightRotationMove.setCost(0);
            puzzle.addMove(rightRotationMove);
            log.info("Generating x'");
            Move rightRotationPriveMove = new Move();
            rightRotationPriveMove.setName(CuboidBuilder.getMoveName(0, 'R', -1));
            rightRotationPriveMove.setImageIcon(CuboidMoveIconBuilder.builer(width, height, rightRotationPriveMove.getName()).fillFrontFace().setRotation('R', true).getImage());
            rightRotationPriveMove.getLoops().addAll(CuboidBuilder.faceReverseTurn(right, depth, height));
            rightRotationPriveMove.getLoops().addAll(CuboidBuilder.faceTurn(left, depth, height));
            for (layer = 1; layer <= width; ++layer) {
                rightRotationPriveMove.getLoops().addAll(CuboidBuilder.rightSideReverseTurn(layer, width, height, depth, front, back, top, bottom));
            }
            rightRotationPriveMove.setCost(0);
            puzzle.addMove(rightRotationPriveMove);
        }
        for (int deep = 1; deep < depth; ++deep) {
            log.info("Generating F2");
            Move f2Move = new Move();
            f2Move.setName(CuboidBuilder.getMoveName(deep, 'F', 2));
            f2Move.setImageIcon(CuboidMoveIconBuilder.builer(width, height, f2Move.getName()).fillFrontFace().setRotation('F', false).getImage());
            f2Move.getLoops().addAll(CuboidBuilder.faceDoubleTurn(front, width, height));
            for (int layer15 = 1; layer15 <= deep; ++layer15) {
                f2Move.getLoops().addAll(CuboidBuilder.frontSideDoubleTurn(layer15, width, height, depth, left, right, top, bottom));
            }
            f2Move.setCost(1);
            puzzle.addMove(f2Move);
            log.info("Generating B2");
            Move b2Move = new Move();
            b2Move.setName(CuboidBuilder.getMoveName(deep, 'B', 2));
            b2Move.setImageIcon(CuboidMoveIconBuilder.builer(width, height, b2Move.getName()).setRotation('B', false).getImage());
            b2Move.getLoops().addAll(CuboidBuilder.faceDoubleTurn(back, width, height));
            for (int layer16 = 1; layer16 <= deep; ++layer16) {
                b2Move.getLoops().addAll(CuboidBuilder.frontSideDoubleTurn(depth - layer16 + 1, width, height, depth, left, right, top, bottom));
            }
            b2Move.setCost(1);
            puzzle.addMove(b2Move);
        }
        log.info("Generating z2");
        Move z2Move = new Move();
        z2Move.setName(CuboidBuilder.getMoveName(0, 'F', 2));
        z2Move.setImageIcon(CuboidMoveIconBuilder.builer(width, height, z2Move.getName()).fillFrontFace().setRotation('F', false).getImage());
        z2Move.getLoops().addAll(CuboidBuilder.faceDoubleTurn(front, width, height));
        z2Move.getLoops().addAll(CuboidBuilder.faceDoubleTurn(back, width, height));
        for (int layer17 = 1; layer17 <= depth; ++layer17) {
            z2Move.getLoops().addAll(CuboidBuilder.frontSideDoubleTurn(layer17, width, height, depth, left, right, top, bottom));
        }
        z2Move.setCost(0);
        puzzle.addMove(z2Move);
        for (int deep = 1; deep < height; ++deep) {
            log.info("Generating U2 to depth {}", (Object)deep);
            Move u2Move = new Move();
            u2Move.setName(CuboidBuilder.getMoveName(deep, 'U', 2));
            u2Move.setImageIcon(CuboidMoveIconBuilder.builer(width, height, u2Move.getName()).fillFromTop(deep).setRotation('U', false).getImage());
            u2Move.getLoops().addAll(CuboidBuilder.faceDoubleTurn(top, width, depth));
            for (int layer18 = 1; layer18 <= deep; ++layer18) {
                u2Move.getLoops().addAll(CuboidBuilder.topSideDoubleTurn(layer18, width, height, depth, right, left, front, back));
            }
            u2Move.setCost(1);
            puzzle.addMove(u2Move);
            log.info("Generating D2 to depth {}", (Object)deep);
            Move d2Move = new Move();
            d2Move.setName(CuboidBuilder.getMoveName(deep, 'D', 2));
            d2Move.setImageIcon(CuboidMoveIconBuilder.builer(width, height, d2Move.getName()).fillFromBottom(deep).setRotation('D', false).getImage());
            d2Move.getLoops().addAll(CuboidBuilder.faceDoubleTurn(bottom, width, depth));
            for (int layer19 = 1; layer19 <= deep; ++layer19) {
                d2Move.getLoops().addAll(CuboidBuilder.topSideDoubleTurn(height - layer19 + 1, width, height, depth, right, left, front, back));
            }
            d2Move.setCost(1);
            puzzle.addMove(d2Move);
        }
        log.info("Generating y2");
        Move y2Move = new Move();
        y2Move.setName(CuboidBuilder.getMoveName(0, 'U', 2));
        y2Move.setImageIcon(CuboidMoveIconBuilder.builer(width, height, y2Move.getName()).fillFrontFace().setRotation('U', false).getImage());
        y2Move.getLoops().addAll(CuboidBuilder.faceDoubleTurn(top, width, depth));
        y2Move.getLoops().addAll(CuboidBuilder.faceDoubleTurn(bottom, width, depth));
        for (int layer20 = 1; layer20 <= height; ++layer20) {
            y2Move.getLoops().addAll(CuboidBuilder.topSideDoubleTurn(layer20, width, height, depth, right, left, front, back));
        }
        y2Move.setCost(0);
        puzzle.addMove(y2Move);
        for (int deep = 1; deep < width; ++deep) {
            log.info("Generating R2 to depth {}", (Object)deep);
            Move r2Move = new Move();
            r2Move.setName(CuboidBuilder.getMoveName(deep, 'R', 2));
            r2Move.setImageIcon(CuboidMoveIconBuilder.builer(width, height, r2Move.getName()).fillFromRight(deep).setRotation('R', false).getImage());
            r2Move.getLoops().addAll(CuboidBuilder.faceDoubleTurn(right, depth, height));
            for (int layer21 = 1; layer21 <= deep; ++layer21) {
                r2Move.getLoops().addAll(CuboidBuilder.rightSideDoubleTurn(layer21, width, height, depth, front, back, top, bottom));
            }
            r2Move.setCost(1);
            puzzle.addMove(r2Move);
            log.info("Generating L2 to depth {}", (Object)deep);
            Move l2Move = new Move();
            l2Move.setName(CuboidBuilder.getMoveName(deep, 'L', 2));
            l2Move.setImageIcon(CuboidMoveIconBuilder.builer(width, height, l2Move.getName()).fillFromLeft(deep).setRotation('L', false).getImage());
            l2Move.getLoops().addAll(CuboidBuilder.faceDoubleTurn(left, depth, height));
            for (layer2 = 1; layer2 <= deep; ++layer2) {
                l2Move.getLoops().addAll(CuboidBuilder.rightSideDoubleTurn(width - layer2 + 1, width, height, depth, front, back, top, bottom));
            }
            l2Move.setCost(1);
            puzzle.addMove(l2Move);
        }
        log.info("Generating x2");
        Move x2Move = new Move();
        x2Move.setName(CuboidBuilder.getMoveName(0, 'R', 2));
        x2Move.setImageIcon(CuboidMoveIconBuilder.builer(width, height, x2Move.getName()).setRotation('R', false).getImage());
        x2Move.getLoops().addAll(CuboidBuilder.faceDoubleTurn(right, depth, height));
        x2Move.getLoops().addAll(CuboidBuilder.faceDoubleTurn(left, depth, height));
        for (int layer22 = 1; layer22 <= width; ++layer22) {
            x2Move.getLoops().addAll(CuboidBuilder.rightSideDoubleTurn(layer22, width, height, depth, front, back, top, bottom));
        }
        x2Move.setCost(0);
        puzzle.addMove(x2Move);
        puzzle.centerPuzzle();
        puzzle.takeSnapshot();
        log.info("Finished building puzzle with {} cells, {} compiled moves", (Object)puzzle.getCells().size(), (Object)puzzle.getCompiledMoves().size());
        return puzzle;
    }

    private static List<Cell> createGrid(int x, int y, int w, int h, ColourEnum colour, int scale) {
        ArrayList<Cell> cells = new ArrayList<Cell>();
        for (int dy = 0; dy < h; ++dy) {
            for (int dx = 0; dx < w; ++dx) {
                Cell c = new Cell();
                c.setShape(ShapeEnum.SQUARE);
                c.setColour(colour);
                c.setLocationX(x + dx * scale * 2);
                c.setLocationY(y + dy * scale * 2);
                c.setScale(scale);
                cells.add(c);
            }
        }
        return cells;
    }

    public static String getMoveName(int depth, char face, int quarterTurns) {
        StringBuilder result = new StringBuilder();
        if (depth > 2) {
            result.append(depth);
        }
        if (depth > 0) {
            result.append(face);
        } else {
            switch (face) {
                case 'R': {
                    result.append("x");
                    break;
                }
                case 'U': {
                    result.append("y");
                    break;
                }
                case 'F': {
                    result.append("z");
                    break;
                }
                default: {
                    result.append("?");
                }
            }
        }
        if (depth > 1) {
            result.append("w");
        }
        if (quarterTurns == 2) {
            result.append("2");
        } else if (quarterTurns == -1) {
            result.append("'");
        }
        return result.toString();
    }

    private static List<MoveLoop> faceTurn(List<Cell> face, int width, int height) {
        ArrayList<MoveLoop> result = new ArrayList<MoveLoop>();
        for (int dx = 0; dx < CuboidBuilder.divRoundUp(width, 2); ++dx) {
            for (int dy = 0; dy < height / 2; ++dy) {
                MoveLoop loop = new MoveLoop();
                loop.getCells().add(face.get(dx + dy * width));
                loop.getCells().add(face.get(width - dy - 1 + width * dx));
                loop.getCells().add(face.get(width - dx - 1 + width * (height - dy - 1)));
                loop.getCells().add(face.get(dy + width * (height - dx - 1)));
                result.add(loop);
            }
        }
        return result;
    }

    private static List<MoveLoop> frontSideTurn(int layer, int width, int height, int depth, List<Cell> left, List<Cell> right, List<Cell> top, List<Cell> bottom) {
        if (width != height) {
            throw new IllegalStateException();
        }
        ArrayList<MoveLoop> result = new ArrayList<MoveLoop>();
        for (int i = 0; i < width; ++i) {
            MoveLoop loop = new MoveLoop();
            loop.getCells().add(top.get(i + width * (depth - layer)));
            loop.getCells().add(right.get(layer - 1 + i * depth));
            loop.getCells().add(bottom.get(width - i - 1 + width * (layer - 1)));
            loop.getCells().add(left.get(depth - layer + (height - i - 1) * depth));
            result.add(loop);
        }
        return result;
    }

    private static List<MoveLoop> faceReverseTurn(List<Cell> face, int width, int height) {
        List<MoveLoop> result = CuboidBuilder.faceTurn(face, width, height);
        for (MoveLoop loop : result) {
            Collections.reverse(loop.getCells());
        }
        return result;
    }

    private static List<MoveLoop> frontSideReverseTurn(int layer, int width, int height, int depth, List<Cell> left, List<Cell> right, List<Cell> top, List<Cell> bottom) {
        List<MoveLoop> result = CuboidBuilder.frontSideTurn(layer, width, height, depth, left, right, top, bottom);
        for (MoveLoop loop : result) {
            Collections.reverse(loop.getCells());
        }
        return result;
    }

    private static List<MoveLoop> topSideTurn(int layer, int width, int height, int depth, List<Cell> left, List<Cell> right, List<Cell> front, List<Cell> back) {
        if (width != depth) {
            throw new IllegalStateException();
        }
        ArrayList<MoveLoop> result = new ArrayList<MoveLoop>();
        for (int i = 0; i < width; ++i) {
            MoveLoop loop = new MoveLoop();
            loop.getCells().add(front.get(i + (layer - 1) * width));
            loop.getCells().add(left.get(i + (layer - 1) * width));
            loop.getCells().add(back.get(i + (layer - 1) * width));
            loop.getCells().add(right.get(i + (layer - 1) * depth));
            result.add(loop);
        }
        return result;
    }

    private static List<MoveLoop> topSideReverseTurn(int layer, int width, int height, int depth, List<Cell> left, List<Cell> right, List<Cell> front, List<Cell> back) {
        List<MoveLoop> result = CuboidBuilder.topSideTurn(layer, width, height, depth, left, right, front, back);
        for (MoveLoop loop : result) {
            Collections.reverse(loop.getCells());
        }
        return result;
    }

    private static List<MoveLoop> rightSideTurn(int layer, int width, int height, int depth, List<Cell> front, List<Cell> back, List<Cell> top, List<Cell> bottom) {
        if (height != depth) {
            throw new IllegalStateException();
        }
        ArrayList<MoveLoop> result = new ArrayList<MoveLoop>();
        for (int i = 0; i < height; ++i) {
            MoveLoop loop = new MoveLoop();
            loop.getCells().add(front.get(width - layer + i * width));
            loop.getCells().add(top.get(width - layer + i * width));
            loop.getCells().add(back.get(layer - 1 + (height - i - 1) * width));
            loop.getCells().add(bottom.get(width - layer + i * width));
            result.add(loop);
        }
        return result;
    }

    private static List<MoveLoop> rightSideReverseTurn(int layer, int width, int height, int depth, List<Cell> front, List<Cell> back, List<Cell> top, List<Cell> bottom) {
        List<MoveLoop> result = CuboidBuilder.rightSideTurn(layer, width, height, depth, front, back, top, bottom);
        for (MoveLoop loop : result) {
            Collections.reverse(loop.getCells());
        }
        return result;
    }

    private static List<MoveLoop> faceDoubleTurn(List<Cell> face, int width, int height) {
        MoveLoop loop;
        ArrayList<MoveLoop> result = new ArrayList<MoveLoop>();
        for (int dx = 0; dx < width; ++dx) {
            for (int dy = 0; dy < height / 2; ++dy) {
                loop = new MoveLoop();
                loop.getCells().add(face.get(dx + dy * width));
                loop.getCells().add(face.get(width - dx - 1 + width * (height - dy - 1)));
                result.add(loop);
            }
        }
        if (height % 2 == 1) {
            int dy = CuboidBuilder.divRoundUp(height, 2) - 1;
            for (int dx = 0; dx < width / 2; ++dx) {
                loop = new MoveLoop();
                loop.getCells().add(face.get(dx + dy * width));
                loop.getCells().add(face.get(width - dx - 1 + dy * width));
                result.add(loop);
            }
        }
        return result;
    }

    private static List<MoveLoop> frontSideDoubleTurn(int layer, int width, int height, int depth, List<Cell> left, List<Cell> right, List<Cell> top, List<Cell> bottom) {
        MoveLoop l;
        int i;
        ArrayList<MoveLoop> result = new ArrayList<MoveLoop>();
        for (i = 0; i < width; ++i) {
            l = new MoveLoop();
            l.getCells().add(top.get(i + (depth - layer) * width));
            l.getCells().add(bottom.get(width - i - 1 + (layer - 1) * width));
            result.add(l);
        }
        for (i = 0; i < height; ++i) {
            l = new MoveLoop();
            l.getCells().add(right.get(layer - 1 + i * depth));
            l.getCells().add(left.get(depth - layer + (height - i - 1) * depth));
            result.add(l);
        }
        return result;
    }

    private static List<MoveLoop> topSideDoubleTurn(int layer, int width, int height, int depth, List<Cell> right, List<Cell> left, List<Cell> front, List<Cell> back) {
        MoveLoop l;
        int i;
        ArrayList<MoveLoop> result = new ArrayList<MoveLoop>();
        for (i = 0; i < width; ++i) {
            l = new MoveLoop();
            l.getCells().add(front.get(i + (layer - 1) * width));
            l.getCells().add(back.get(i + (layer - 1) * width));
            result.add(l);
        }
        for (i = 0; i < depth; ++i) {
            l = new MoveLoop();
            l.getCells().add(right.get(i + (layer - 1) * depth));
            l.getCells().add(left.get(i + (layer - 1) * depth));
            result.add(l);
        }
        return result;
    }

    private static List<MoveLoop> rightSideDoubleTurn(int layer, int width, int height, int depth, List<Cell> front, List<Cell> back, List<Cell> top, List<Cell> bottom) {
        MoveLoop l;
        int i;
        ArrayList<MoveLoop> result = new ArrayList<MoveLoop>();
        for (i = 0; i < height; ++i) {
            l = new MoveLoop();
            l.getCells().add(front.get(i * width + width - layer));
            l.getCells().add(back.get((height - i - 1) * width + layer - 1));
            result.add(l);
        }
        for (i = 0; i < depth; ++i) {
            l = new MoveLoop();
            l.getCells().add(top.get(i * width + width - layer));
            l.getCells().add(bottom.get(i * width + width - layer));
            result.add(l);
        }
        return result;
    }

    public static int divRoundUp(int num, int divisor) {
        return (num + divisor - 1) / divisor;
    }

    @Generated
    private CuboidBuilder() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

