/*
 * Decompiled with CFR 0.152.
 */
package dev.aisandbox.server.simulation.maze;

import dev.aisandbox.server.engine.Agent;
import dev.aisandbox.server.engine.Simulation;
import dev.aisandbox.server.engine.Theme;
import dev.aisandbox.server.engine.exception.SimulationException;
import dev.aisandbox.server.engine.output.OutputConstants;
import dev.aisandbox.server.engine.output.OutputRenderer;
import dev.aisandbox.server.engine.output.SpriteLoader;
import dev.aisandbox.server.engine.widget.RollingValueChartWidget;
import dev.aisandbox.server.engine.widget.TextWidget;
import dev.aisandbox.server.engine.widget.TitleWidget;
import dev.aisandbox.server.simulation.maze.Cell;
import dev.aisandbox.server.simulation.maze.Direction;
import dev.aisandbox.server.simulation.maze.Maze;
import dev.aisandbox.server.simulation.maze.MazeGenerator;
import dev.aisandbox.server.simulation.maze.MazeSize;
import dev.aisandbox.server.simulation.maze.MazeType;
import dev.aisandbox.server.simulation.maze.proto.MazeAction;
import dev.aisandbox.server.simulation.maze.proto.MazeResult;
import dev.aisandbox.server.simulation.maze.proto.MazeState;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MazeRunner
implements Simulation {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MazeRunner.class);
    public static final int SPRITE_SIZE = 25;
    private static final int BAIZE_HEIGHT = 880;
    private static final int BAIZE_WIDTH = 1173;
    private static final int LOG_WIDTH = 597;
    private static final int MAZE_START_X = 136;
    private static final int LOG_HEIGHT = 415;
    private static final int MAZE_START_Y = 215;
    private static final double REWARD_STEP = -1.0;
    private static final double REWARD_HIT_WALL = -10.0;
    private static final double REWARD_GOAL = 1000.0;
    private static final int EPISODE_LENGTH = 2000;
    private final TitleWidget titleWidget;
    private final TextWidget logWidget;
    private final RollingValueChartWidget episodeScoreWidget;
    private final MazeSize mazeSize;
    private final MazeType mazeType;
    private final Theme theme;
    private final List<BufferedImage> sprites;
    private final Random random;
    private final Agent agent;
    private final String sessionID = UUID.randomUUID().toString();
    private int stepsLeft;
    private Maze maze;
    private BufferedImage mazeImage = null;
    private Cell currentCell;
    private String episodeID;
    private double episodeScore;

    public MazeRunner(Agent agent, MazeSize mazeSize, MazeType mazeType, Theme theme, Random random) {
        this.agent = agent;
        this.mazeSize = mazeSize;
        this.mazeType = mazeType;
        this.theme = theme;
        this.random = random;
        this.sprites = SpriteLoader.loadSpritesFromResources("/images/maze/bridge.png", 25, 25);
        this.titleWidget = TitleWidget.builder().title("Maze - " + mazeType.name()).theme(theme).build();
        this.logWidget = TextWidget.builder().width(597).height(415).font(OutputConstants.LOG_FONT).theme(theme).build();
        this.episodeScoreWidget = RollingValueChartWidget.builder().width(597).height(415).theme(theme).window(200).build();
        this.initialiseMaze();
    }

    private void initialiseMaze() {
        this.maze = MazeGenerator.generateMaze(this.mazeSize, this.mazeType, this.random);
        this.stepsLeft = 2000;
        this.episodeScore = 0.0;
        this.mazeImage = this.renderMaze(this.maze);
        this.currentCell = this.maze.getStartCell();
        this.episodeID = UUID.randomUUID().toString();
    }

    public BufferedImage renderMaze(Maze maze) {
        BufferedImage image = new BufferedImage(maze.getWidth() * 25, maze.getHeight() * 25, 1);
        Graphics2D g = image.createGraphics();
        for (Cell c : maze.getCellList()) {
            int icon = 0;
            if (!c.isPath(Direction.NORTH)) {
                ++icon;
            }
            if (!c.isPath(Direction.EAST)) {
                icon += 2;
            }
            if (!c.isPath(Direction.SOUTH)) {
                icon += 4;
            }
            if (!c.isPath(Direction.WEST)) {
                icon += 8;
            }
            g.drawImage((Image)this.sprites.get(icon), c.getPositionX() * 25, c.getPositionY() * 25, null);
        }
        Cell finish = maze.getEndCell();
        if (finish != null) {
            g.drawImage((Image)this.sprites.get(18), finish.getPositionX() * 25, finish.getPositionY() * 25, null);
        }
        return image;
    }

    @Override
    public void step(OutputRenderer output) throws SimulationException {
        double score;
        output.display();
        int startX = this.currentCell.getPositionX();
        int startY = this.currentCell.getPositionY();
        MazeState state = MazeState.newBuilder().setSessionID(this.sessionID).setEpisodeID(this.episodeID).setMovesLeft(this.stepsLeft).setStartX(startX).setStartY(startY).setWidth(this.maze.getWidth()).setHeight(this.maze.getHeight()).build();
        this.agent.send(state);
        MazeAction action = this.agent.receive(MazeAction.class);
        Direction direction = Direction.fromProto(action.getDirection());
        log.info("{} moves {}", (Object)this.agent.getAgentName(), (Object)direction);
        --this.stepsLeft;
        if (this.currentCell.getPaths().contains((Object)direction)) {
            this.currentCell = this.currentCell.getNeighbours().get((Object)direction);
            score = this.currentCell.equals(this.maze.getEndCell()) ? 1000.0 : -1.0;
        } else {
            score = -10.0;
        }
        this.logWidget.addText("Move " + direction.name() + " (" + score + ")");
        this.episodeScore += score;
        this.agent.send(MazeResult.newBuilder().setStartX(startX).setStartY(startY).setEndX(this.currentCell.getPositionX()).setEndY(this.currentCell.getPositionY()).setDirection(action.getDirection()).setStepScore(score).setAccumulatedScore(this.episodeScore).build());
        if (this.currentCell.equals(this.maze.getEndCell())) {
            output.display();
            this.currentCell = this.maze.getStartCell();
        }
        if (this.stepsLeft == 0) {
            this.logWidget.addText("Episode finished, resetting maze");
            this.episodeScoreWidget.addValue(this.episodeScore);
            this.initialiseMaze();
        }
    }

    @Override
    public void visualise(Graphics2D graphics2D) {
        graphics2D.setColor(this.theme.getBackground());
        graphics2D.fillRect(0, 0, 1920, 1080);
        graphics2D.drawImage((Image)this.titleWidget.getImage(), 0, 50, null);
        graphics2D.drawImage((Image)OutputConstants.LOGO, 1779, 21, null);
        graphics2D.setColor(this.theme.getBaize());
        graphics2D.fillRect(50, 150, 1173, 880);
        graphics2D.drawImage(this.mazeImage, 136, 215, this.maze.getWidth() * 25 * this.maze.getZoomLevel(), this.maze.getHeight() * 25 * this.maze.getZoomLevel(), null);
        graphics2D.setColor(this.theme.getAgent1Main());
        graphics2D.fillOval(this.currentCell.getPositionX() * this.mazeSize.getZoomLevel() * 25 + 136, 215 + this.currentCell.getPositionY() * this.mazeSize.getZoomLevel() * 25, this.mazeSize.getZoomLevel() * 25, this.mazeSize.getZoomLevel() * 25);
        graphics2D.drawImage((Image)this.logWidget.getImage(), 1273, 615, null);
        graphics2D.drawImage((Image)this.episodeScoreWidget.getImage(), 1273, 150, null);
    }
}

