/*
 * Decompiled with CFR 0.152.
 */
package dev.aisandbox.server.simulation.highlowcards;

import dev.aisandbox.server.engine.Agent;
import dev.aisandbox.server.engine.Simulation;
import dev.aisandbox.server.engine.Theme;
import dev.aisandbox.server.engine.exception.SimulationException;
import dev.aisandbox.server.engine.maths.bins.IntegerBinner;
import dev.aisandbox.server.engine.output.OutputConstants;
import dev.aisandbox.server.engine.output.OutputRenderer;
import dev.aisandbox.server.engine.widget.RollingStatisticsWidget;
import dev.aisandbox.server.engine.widget.RollingValueChartWidget;
import dev.aisandbox.server.engine.widget.RollingValueHistogramWidget;
import dev.aisandbox.server.engine.widget.TextWidget;
import dev.aisandbox.server.engine.widget.TitleWidget;
import dev.aisandbox.server.simulation.common.Card;
import dev.aisandbox.server.simulation.common.Deck;
import dev.aisandbox.server.simulation.highlowcards.proto.HighLowCardsAction;
import dev.aisandbox.server.simulation.highlowcards.proto.HighLowCardsReward;
import dev.aisandbox.server.simulation.highlowcards.proto.HighLowCardsState;
import dev.aisandbox.server.simulation.highlowcards.proto.HighLowChoice;
import dev.aisandbox.server.simulation.highlowcards.proto.Signal;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HighLowCards
implements Simulation {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HighLowCards.class);
    private static final int BAIZE_WIDTH = 1370;
    private static final int BAIZE_HEIGHT = 518;
    private static final int BAIZE_PADDING = 30;
    private static final int CARD_GAP = 30;
    private static final int STATISTICS_WIDTH = 400;
    private static final int STATISTICS_HEIGHT = 518;
    private static final int RESULTS_WIDTH = 573;
    private static final int RESULTS_HEIGHT = 312;
    private final int CARD_SPACE;
    private final Map<String, BufferedImage> cardImages = new HashMap<String, BufferedImage>();
    private final Theme theme;
    private final Agent agent;
    private final int cardCount;
    private final Random random;
    private final List<Card> faceUpCards = new ArrayList<Card>();
    private final List<Card> faceDownCards = new ArrayList<Card>();
    private final String sessionID = UUID.randomUUID().toString();
    private final TitleWidget titleWidget;
    private final RollingValueChartWidget scoreWidget;
    private final RollingValueHistogramWidget scoreHistogramWidget;
    private final TextWidget logWidget;
    private final RollingStatisticsWidget statisticsWidget;
    private String episodeID;
    private int score = 0;

    public HighLowCards(Agent agent, int cardCount, Theme theme, Random random) {
        this.agent = agent;
        this.cardCount = cardCount;
        this.theme = theme;
        this.random = random;
        this.titleWidget = TitleWidget.builder().title("High / Low Cards").theme(theme).build();
        this.scoreWidget = RollingValueChartWidget.builder().width(573).height(312).window(200).theme(theme).title("Final Score").build();
        this.scoreHistogramWidget = RollingValueHistogramWidget.builder().width(573).height(312).window(200).binEngine(new IntegerBinner(0, cardCount)).theme(theme).title("Score Distribution").build();
        this.logWidget = TextWidget.builder().width(573).height(312).font(OutputConstants.LOG_FONT).theme(theme).build();
        this.statisticsWidget = RollingStatisticsWidget.builder().width(400).height(518).theme(theme).build();
        this.CARD_SPACE = 800 / (cardCount - 2);
        this.reset();
    }

    private void reset() {
        Deck deck = new Deck();
        deck.shuffle(this.random);
        this.faceDownCards.clear();
        this.faceUpCards.clear();
        for (int i = 0; i < this.cardCount; ++i) {
            this.faceDownCards.add(deck.getCard());
        }
        this.faceUpCards.add(this.faceDownCards.removeFirst());
        this.episodeID = UUID.randomUUID().toString();
        this.score = 0;
    }

    @Override
    public void step(OutputRenderer output) throws SimulationException {
        boolean correctGuess;
        Card previousCard = this.faceUpCards.getLast();
        Card nextCard = this.faceDownCards.getFirst();
        this.logWidget.addText("Showing " + this.faceUpCards.stream().map(Card::getShortDrescription).collect(Collectors.joining(",")));
        output.display();
        log.debug("Sending current state to agent");
        this.agent.send(HighLowCardsState.newBuilder().setCardCount(this.cardCount).addAllDealtCard(this.faceUpCards.stream().map(Card::getShortDrescription).toList()).setScore(this.score).setSessionID(this.sessionID).setEpisodeID(this.episodeID).build());
        log.debug("Asking agent for action");
        HighLowCardsAction action = this.agent.receive(HighLowCardsAction.class);
        log.debug("Client action: {}", (Object)action.getAction().name());
        this.faceUpCards.add(this.faceDownCards.removeFirst());
        boolean bl = correctGuess = action.getAction() == HighLowChoice.LOW && nextCard.cardValue().getValueAceHigh() < previousCard.cardValue().getValueAceHigh() || action.getAction() == HighLowChoice.HIGH && nextCard.cardValue().getValueAceHigh() > previousCard.cardValue().getValueAceHigh();
        if (correctGuess) {
            ++this.score;
            this.logWidget.addText("[" + this.agent.getAgentName() + "] " + action.getAction().name() + " - correct (" + this.faceUpCards.getLast().getShortDrescription() + ")");
        } else {
            this.logWidget.addText("[" + this.agent.getAgentName() + "] " + action.getAction().name() + " - wrong (" + this.faceUpCards.getLast().getShortDrescription() + ")");
        }
        output.display();
        if (!correctGuess || this.faceDownCards.isEmpty()) {
            this.scoreWidget.addValue(this.score);
            this.statisticsWidget.addScore(this.score);
            this.scoreHistogramWidget.addValue(this.score);
            this.agent.send(HighLowCardsReward.newBuilder().setScore(this.score).setSignal(Signal.RESET).build());
            this.reset();
        } else {
            this.agent.send(HighLowCardsReward.newBuilder().setScore(this.score).setSignal(Signal.CONTINUE).build());
        }
    }

    @Override
    public void visualise(Graphics2D graphics2D) {
        int dx;
        graphics2D.setColor(this.theme.getBackground());
        graphics2D.fillRect(0, 0, 1920, 1080);
        graphics2D.drawImage((Image)this.titleWidget.getImage(), 0, 50, null);
        graphics2D.setColor(this.theme.getBaize());
        graphics2D.fillRect(50, 150, 1370, 518);
        for (dx = 0; dx < this.faceUpCards.size(); ++dx) {
            Card card = this.faceUpCards.get(dx);
            BufferedImage cardImage = this.getCardImage(card.getImageName());
            graphics2D.drawImage((Image)cardImage, dx * this.CARD_SPACE + 50 + 30, 241, null);
        }
        for (dx = this.faceDownCards.size() - 1; dx >= 0; --dx) {
            BufferedImage cardImage = this.getCardImage("/images/cards/1B.png");
            graphics2D.drawImage((Image)cardImage, 110 + (dx + this.faceUpCards.size() - 1) * this.CARD_SPACE + 240, 241, null);
        }
        graphics2D.drawImage((Image)this.scoreWidget.getImage(), 50, 718, null);
        graphics2D.drawImage((Image)this.scoreHistogramWidget.getImage(), 673, 718, null);
        graphics2D.drawImage((Image)this.logWidget.getImage(), 1296, 718, null);
        graphics2D.drawImage((Image)this.statisticsWidget.getImage(), 1470, 150, null);
        graphics2D.drawImage((Image)OutputConstants.LOGO, 1779, 21, null);
    }

    private BufferedImage getCardImage(String path) {
        return this.cardImages.computeIfAbsent(path, s -> {
            try {
                log.debug("Loading image {}", (Object)path);
                return ImageIO.read(HighLowCards.class.getResourceAsStream(path));
            }
            catch (IOException e) {
                log.error("Error loading card image {}", (Object)path, (Object)e);
                return null;
            }
        });
    }
}

