/*
 * Decompiled with CFR 0.152.
 */
package dev.aisandbox.server.simulation.coingame;

import dev.aisandbox.server.engine.Agent;
import dev.aisandbox.server.engine.Simulation;
import dev.aisandbox.server.engine.Theme;
import dev.aisandbox.server.engine.exception.SimulationException;
import dev.aisandbox.server.engine.output.OutputConstants;
import dev.aisandbox.server.engine.output.OutputRenderer;
import dev.aisandbox.server.engine.widget.RollingPieChartWidget;
import dev.aisandbox.server.engine.widget.TextWidget;
import dev.aisandbox.server.engine.widget.TitleWidget;
import dev.aisandbox.server.simulation.coingame.CoinIcons;
import dev.aisandbox.server.simulation.coingame.CoinScenario;
import dev.aisandbox.server.simulation.coingame.IllegalCoinAction;
import dev.aisandbox.server.simulation.coingame.InvalidCoinAction;
import dev.aisandbox.server.simulation.coingame.proto.CoinGameAction;
import dev.aisandbox.server.simulation.coingame.proto.CoinGameResult;
import dev.aisandbox.server.simulation.coingame.proto.CoinGameSignal;
import dev.aisandbox.server.simulation.coingame.proto.CoinGameState;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CoinGame
implements Simulation {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CoinGame.class);
    private static final int BAIZE_HEIGHT = 880;
    private static final int BAIZE_WIDTH = 1173;
    private static final int LOG_WIDTH = 597;
    private static final int LOG_HEIGHT = 415;
    private final int COIN_ROW_INDENT;
    private final int COIN_COLUMN_INDENT = 154;
    private final Theme theme;
    private final TitleWidget titleWidget;
    private final TextWidget logWidget;
    private final RollingPieChartWidget pieChartWidget;
    private final String sessionId = UUID.randomUUID().toString();
    private final Agent[] agents = new Agent[2];
    private final boolean[] agentMoved = new boolean[2];
    private final CoinScenario scenario;
    private int firstPlayer = 1;
    private int currentPlayer = 0;
    private BufferedImage[] rowImages;
    private BufferedImage[] coinImages;
    private String episodeId;
    private int[] coins;

    public CoinGame(List<Agent> agents, CoinScenario scenario, Theme theme) {
        assert (agents.size() == 2);
        this.agents[0] = agents.get(0);
        this.agents[1] = agents.get(1);
        this.scenario = scenario;
        this.theme = theme;
        this.coins = new int[scenario.getRows().length];
        this.titleWidget = TitleWidget.builder().title("The Coin Game").theme(theme).build();
        this.logWidget = TextWidget.builder().width(597).height(415).font(OutputConstants.LOG_FONT).theme(theme).build();
        this.pieChartWidget = RollingPieChartWidget.builder().width(597).height(415).title("Winner of the last 200 episodes.").theme(theme).build();
        this.COIN_ROW_INDENT = (1173 - 290 * scenario.getRows().length) / 2;
        try {
            this.rowImages = CoinIcons.getRowImages(scenario.getRows().length, theme);
            this.coinImages = CoinIcons.getCoinImages(Arrays.stream(scenario.getRows()).max().getAsInt(), theme);
        }
        catch (IOException e) {
            log.error("Error loading images", (Throwable)e);
        }
        this.reset();
    }

    private void reset() {
        System.arraycopy(this.scenario.getRows(), 0, this.coins, 0, this.scenario.getRows().length);
        this.episodeId = UUID.randomUUID().toString();
        this.agentMoved[0] = false;
        this.agentMoved[1] = false;
        this.currentPlayer = this.firstPlayer = (this.firstPlayer + 1) % 2;
    }

    @Override
    public void step(OutputRenderer output) throws SimulationException {
        output.display();
        Agent currentAgent = this.agents[this.currentPlayer];
        log.debug("ask {} to move from state {}", (Object)currentAgent.getAgentName(), (Object)this.coins);
        currentAgent.send(this.generateCurrentState());
        CoinGameAction action = currentAgent.receive(CoinGameAction.class);
        log.debug("{} asked for {} coins from row {}", new Object[]{currentAgent.getAgentName(), action.getRemoveCount(), action.getSelectedRow()});
        this.agentMoved[this.currentPlayer] = true;
        try {
            this.coins = this.makeMove(action.getSelectedRow(), action.getRemoveCount());
            this.logWidget.addText(currentAgent.getAgentName() + " takes " + action.getRemoveCount() + " from row " + action.getSelectedRow() + " leaving " + this.coins[action.getSelectedRow()] + ".");
            if (this.isGameFinished()) {
                this.logWidget.addText(currentAgent.getAgentName() + " lost");
                this.informResult((this.currentPlayer + 1) % 2);
                output.display();
                this.reset();
            } else {
                int otherPlayer = (this.currentPlayer + 1) % 2;
                if (this.agentMoved[otherPlayer]) {
                    this.agents[otherPlayer].send(CoinGameResult.newBuilder().setStatus(CoinGameSignal.PLAY).build());
                }
                this.currentPlayer = otherPlayer;
            }
        }
        catch (InvalidCoinAction e) {
            log.error(e.getMessage());
            this.logWidget.addText(currentAgent.getAgentName() + " makes an invalid move.");
            this.informResult((this.currentPlayer + 1) % 2);
            output.display();
            this.reset();
        }
    }

    private CoinGameState generateCurrentState() {
        return CoinGameState.newBuilder().addAllCoinCount(Arrays.stream(this.coins).boxed().toList()).setRowCount(this.coins.length).setMaxPick(this.scenario.getMaximumTake()).setSessionID(this.sessionId).setEpisodeID(this.episodeId).build();
    }

    private int[] makeMove(int row, int amount) throws SimulationException {
        if (amount < 1 || amount > this.scenario.getMaximumTake()) {
            throw new IllegalCoinAction("Must remove between 1 and " + this.scenario.getMaximumTake() + " coins.");
        }
        if (row < 0 || row >= this.coins.length) {
            throw new IllegalCoinAction("Must select row from 0 to " + (this.coins.length - 1) + ".");
        }
        if (this.coins[row] < amount) {
            throw new InvalidCoinAction("Not enough coins in the selected row, asked for " + amount + " from row " + row + ", only " + this.coins[row] + " available");
        }
        int[] newCoins = Arrays.copyOf(this.coins, this.coins.length);
        int n = row;
        newCoins[n] = newCoins[n] - amount;
        return newCoins;
    }

    private boolean isGameFinished() {
        for (int row = 0; row < this.scenario.getRows().length; ++row) {
            if (this.coins[row] <= 0) continue;
            return false;
        }
        return true;
    }

    private void informResult(int winner) throws SimulationException {
        if (this.agentMoved[0]) {
            this.agents[0].send(CoinGameResult.newBuilder().setStatus(winner == 0 ? CoinGameSignal.WIN : CoinGameSignal.LOSE).build());
        }
        if (this.agentMoved[1]) {
            this.agents[1].send(CoinGameResult.newBuilder().setStatus(winner == 1 ? CoinGameSignal.WIN : CoinGameSignal.LOSE).build());
        }
        this.logWidget.addText(this.agents[winner].getAgentName() + " wins");
        this.pieChartWidget.addValue(this.agents[winner].getAgentName(), this.theme.getAgentMain(winner));
    }

    @Override
    public void visualise(Graphics2D graphics2D) {
        graphics2D.setColor(this.theme.getBackground());
        graphics2D.fillRect(0, 0, 1920, 1080);
        graphics2D.drawImage((Image)this.titleWidget.getImage(), 0, 50, null);
        graphics2D.drawImage((Image)this.pieChartWidget.getImage(), 1273, 150, null);
        graphics2D.drawImage((Image)this.logWidget.getImage(), 1273, 615, null);
        graphics2D.setColor(this.theme.getBaize());
        graphics2D.fillRect(50, 150, 1173, 880);
        graphics2D.setColor(this.theme.getText());
        for (int i = 0; i < this.coins.length; ++i) {
            graphics2D.drawImage((Image)this.rowImages[i], 50 + i * 290 + this.COIN_ROW_INDENT, 304, null);
            graphics2D.drawImage((Image)this.coinImages[this.coins[i]], 50 + i * 290 + this.COIN_ROW_INDENT, 384, null);
        }
        graphics2D.drawImage((Image)OutputConstants.LOGO, 1779, 21, null);
    }
}

