/*
 * Decompiled with CFR 0.152.
 */
package dev.aisandbox.server.engine.widget.axis;

import dev.aisandbox.server.engine.widget.axis.AxisScale;
import dev.aisandbox.server.engine.widget.axis.NiceAxisScale;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public class TightAxisScale
implements AxisScale {
    private final double minimum;
    private final double maximum;
    private final List<Double> ticks;

    public TightAxisScale(double minimum, double maximum, int maxTicks) {
        this.minimum = minimum;
        this.maximum = maximum;
        NiceAxisScale niceAxisScale = new NiceAxisScale(minimum, maximum, maxTicks);
        this.ticks = niceAxisScale.getTicks().stream().filter(t -> minimum <= t && t <= maximum).collect(Collectors.toList());
    }

    @Override
    public double getScaledValue(double value) {
        return (value - this.minimum) / (this.maximum - this.minimum);
    }

    @Override
    public String getValueString(double value) {
        return String.format("%.1f", value);
    }

    @Override
    @Generated
    public double getMinimum() {
        return this.minimum;
    }

    @Override
    @Generated
    public double getMaximum() {
        return this.maximum;
    }

    @Override
    @Generated
    public List<Double> getTicks() {
        return this.ticks;
    }
}

