/*
 * Decompiled with CFR 0.152.
 */
package dev.aisandbox.server.engine.widget.axis;

import dev.aisandbox.server.engine.widget.axis.AxisScale;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class NiceAxisScale
implements AxisScale {
    private final double tickSpacing;
    private final double minimum;
    private final double maximum;

    public NiceAxisScale(double minimumValue, double maximumValue) {
        this(minimumValue, maximumValue, 5);
    }

    public NiceAxisScale(double minimumValue, double maximumValue, int maxTicks) {
        if (minimumValue == maximumValue) {
            minimumValue -= 0.5;
            maximumValue += 0.5;
        }
        double range = NiceAxisScale.nice(maximumValue - minimumValue, false);
        this.tickSpacing = NiceAxisScale.nice(range / (double)(maxTicks - 1), true);
        this.minimum = Math.floor(minimumValue / this.tickSpacing) * this.tickSpacing;
        this.maximum = Math.ceil(maximumValue / this.tickSpacing) * this.tickSpacing;
    }

    protected static double nice(double value, boolean round) {
        double exponent = Math.floor(Math.log10(value));
        double fraction = value / Math.pow(10.0, exponent);
        double niceFraction = round ? (fraction < 1.5 ? 1.0 : (fraction < 3.0 ? 2.0 : (fraction < 7.0 ? 5.0 : 10.0))) : (fraction <= 1.0 ? 1.0 : (fraction <= 2.0 ? 2.0 : (fraction <= 5.0 ? 5.0 : 10.0)));
        return niceFraction * Math.pow(10.0, exponent);
    }

    @Override
    public double getScaledValue(double value) {
        return (value - this.minimum) / (this.maximum - this.minimum);
    }

    @Override
    public String getValueString(double value) {
        return String.format("%.1f", value);
    }

    @Override
    public List<Double> getTicks() {
        ArrayList<Double> ticks = new ArrayList<Double>();
        for (double currentTick = this.minimum; currentTick <= this.maximum; currentTick += this.tickSpacing) {
            ticks.add(currentTick);
        }
        return ticks;
    }

    @Override
    @Generated
    public double getMinimum() {
        return this.minimum;
    }

    @Override
    @Generated
    public double getMaximum() {
        return this.maximum;
    }
}

