/*
 * Decompiled with CFR 0.152.
 */
package dev.aisandbox.server.engine.widget;

import dev.aisandbox.server.engine.Theme;
import dev.aisandbox.server.engine.output.OutputConstants;
import dev.aisandbox.server.engine.widget.GraphicsUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Arc2D;
import java.awt.image.BufferedImage;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PieChartWidget {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PieChartWidget.class);
    private static final int PADDING = 16;
    private static final int TITLE_FONT_SIZE = 18;
    private static final Font TITLE_FONT = new Font("Arial", 1, 18);
    private final int width;
    private final int height;
    private final String title;
    private final Theme theme;
    private BufferedImage image;
    private List<Slice> segments = List.of();

    public PieChartWidget(int width, int height, String title, Theme theme) {
        this.width = width;
        this.height = height;
        this.title = title;
        this.theme = theme;
        this.image = this.drawGraph();
    }

    private BufferedImage drawGraph() {
        double angle;
        double value;
        BufferedImage image = GraphicsUtils.createBlankImage(this.width, this.height, this.theme.getWidgetBackground());
        Graphics2D g = image.createGraphics();
        g.setColor(this.theme.getGraphBackground());
        g.fillRect(16, 16, this.width - 32, this.height - 32);
        GraphicsUtils.drawCenteredText(g, 16, 16, this.width - 32, 18, this.title, TITLE_FONT, this.theme.getText());
        int pieDiameter = Math.min(this.width - 64, this.height - 64 - 18);
        int startX = (this.width - pieDiameter) / 2;
        int startY = (this.height - 32 - 18 - pieDiameter) / 2 + 16 + 18;
        double totalValue = 0.0;
        for (Slice slice : this.segments) {
            totalValue += slice.value;
        }
        double startAngle = 90.0;
        for (Slice slice : this.segments) {
            value = slice.value / totalValue;
            angle = value * 360.0;
            g.setColor(slice.baseColor);
            Arc2D.Double arc = new Arc2D.Double(startX, startY, pieDiameter, pieDiameter, startAngle, -angle, 2);
            Rectangle bounds = arc.getBounds();
            g.fill(arc);
            g.setColor(this.theme.getGraphBackground());
            g.draw(arc);
            startAngle -= angle;
        }
        startAngle = -1.5707963267948966;
        g.setColor(this.theme.getText());
        for (Slice slice : this.segments) {
            value = slice.value / totalValue;
            angle = value * 360.0 * Math.PI / 180.0;
            double midAngle = startAngle + angle / 2.0;
            int textX = (int)((double)(startX + pieDiameter / 2) + Math.cos(midAngle) * (double)pieDiameter / 3.0);
            int textY = (int)((double)(startY + pieDiameter / 2) + Math.sin(midAngle) * (double)pieDiameter / 3.0);
            GraphicsUtils.drawCenteredText(g, textX - 20, textY - 10, 40, 20, slice.title, OutputConstants.LOG_FONT, Color.WHITE);
            startAngle += angle;
        }
        return image;
    }

    public static PieChartWidgetBuilder builder() {
        return new PieChartWidgetBuilder();
    }

    public void setPie(List<Slice> segments) {
        this.segments = segments;
        this.image = this.drawGraph();
    }

    @Generated
    public BufferedImage getImage() {
        return this.image;
    }

    public record Slice(String title, double value, Color baseColor) {
    }

    public static class PieChartWidgetBuilder {
        private int width = 200;
        private int height = 200;
        private String title = "Pie Chart";
        private Theme theme = Theme.LIGHT;

        public PieChartWidget build() {
            return new PieChartWidget(this.width, this.height, this.title, this.theme);
        }

        @Generated
        public PieChartWidgetBuilder width(int width) {
            this.width = width;
            return this;
        }

        @Generated
        public PieChartWidgetBuilder height(int height) {
            this.height = height;
            return this;
        }

        @Generated
        public PieChartWidgetBuilder title(String title) {
            this.title = title;
            return this;
        }

        @Generated
        public PieChartWidgetBuilder theme(Theme theme) {
            this.theme = theme;
            return this;
        }
    }
}

