/*
 * Decompiled with CFR 0.152.
 */
package dev.aisandbox.server.engine.widget;

import dev.aisandbox.server.engine.Theme;
import dev.aisandbox.server.engine.widget.GraphicsUtils;
import dev.aisandbox.server.engine.widget.axis.AxisScale;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseGraph {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseGraph.class);
    private static final int PADDING = 16;
    private static final int MARGIN = 3;
    private static final int TITLE_FONT_SIZE = 18;
    private static final Font TITLE_FONT = new Font("Arial", 1, 18);
    private static final int AXIS_FONT_SIZE = 12;
    private static final Font AXIS_FONT = new Font("Arial", 0, 12);
    private static final int TICK_FONT_SIZE = 10;
    private static final Font TICK_FONT = new Font("Arial", 0, 10);
    private static final float[] dash1 = new float[]{10.0f};
    private static final BasicStroke dashed = new BasicStroke(1.0f, 0, 0, 10.0f, dash1, 0.0f);
    private final int width;
    private final int height;
    private final String title;
    private final String xAxisTitle;
    private final String yAxisTitle;
    private final Theme theme;
    private final AxisScale xAxisScale;
    private final AxisScale yAxisScale;
    private final BufferedImage image;
    private final Graphics2D graphics;
    private final int xBoxStart;
    private final int boxWidth;
    private final int yBoxStart;
    private final int boxHeight;

    public BaseGraph(int width, int height, String title, String xAxisTitle, String yAxisTitle, Theme theme, AxisScale xAxisScale, AxisScale yAxisScale) {
        this.width = width;
        this.height = height;
        this.title = title;
        this.xAxisTitle = xAxisTitle;
        this.yAxisTitle = yAxisTitle;
        this.theme = theme;
        this.xAxisScale = xAxisScale;
        this.yAxisScale = yAxisScale;
        this.image = GraphicsUtils.createBlankImage(width, height, theme.getWidgetBackground());
        this.graphics = this.image.createGraphics();
        GraphicsUtils.setupRenderingHints(this.graphics);
        this.xBoxStart = 50;
        this.boxWidth = width - this.xBoxStart - 16;
        this.yBoxStart = 37;
        this.boxHeight = height - this.yBoxStart - 16 - 12 - 9 - 10;
        this.graphics.setColor(theme.getGraphBackground());
        this.graphics.fillRect(this.xBoxStart, this.yBoxStart, this.boxWidth, this.boxHeight);
        this.graphics.setColor(theme.getGraphOutlineColor());
        Stroke line = this.graphics.getStroke();
        this.graphics.setStroke(dashed);
        for (double x : xAxisScale.getTicks()) {
            int dx = (int)((double)this.boxWidth * xAxisScale.getScaledValue(x));
            this.graphics.drawLine(this.xBoxStart + dx, this.yBoxStart, this.xBoxStart + dx, this.yBoxStart + this.boxHeight);
        }
        for (double y : yAxisScale.getTicks()) {
            int dy = (int)((double)this.boxHeight * (1.0 - yAxisScale.getScaledValue(y)));
            this.graphics.drawLine(this.xBoxStart, this.yBoxStart + dy, this.xBoxStart + this.boxWidth, this.yBoxStart + dy);
        }
        this.graphics.setStroke(line);
    }

    public void addLine(double startX, double startY, double endX, double endY, Color colour) {
        int x1 = (int)(this.xAxisScale.getScaledValue(startX) * (double)this.boxWidth);
        int y1 = (int)(this.yAxisScale.getScaledValue(startY) * (double)this.boxHeight);
        int x2 = (int)(this.xAxisScale.getScaledValue(endX) * (double)this.boxWidth);
        int y2 = (int)(this.yAxisScale.getScaledValue(endY) * (double)this.boxHeight);
        this.graphics.setColor(colour);
        this.graphics.drawLine(this.xBoxStart + x1, this.yBoxStart + this.boxHeight - y1, this.xBoxStart + x2, this.yBoxStart + this.boxHeight - y2);
    }

    public void addBox(double startX, double startY, double endX, double endY, Color fillColour, Color outlineColour) {
        int x1 = (int)(this.xAxisScale.getScaledValue(startX) * (double)this.boxWidth);
        int y1 = (int)(this.yAxisScale.getScaledValue(startY) * (double)this.boxHeight);
        int x2 = (int)(this.xAxisScale.getScaledValue(endX) * (double)this.boxWidth);
        int y2 = (int)(this.yAxisScale.getScaledValue(endY) * (double)this.boxHeight);
        int x = Math.min(x1, x2);
        int width = Math.abs(x1 - x2);
        int y = Math.max(y1, y2);
        int height = Math.abs(y1 - y2);
        this.graphics.setColor(fillColour);
        this.graphics.fillRect(this.xBoxStart + x, this.yBoxStart + this.boxHeight - y, width, height);
        this.graphics.setColor(outlineColour);
        this.graphics.drawRect(this.xBoxStart + x, this.yBoxStart + this.boxHeight - y, width, height);
    }

    public void addAxisAndTitle() {
        GraphicsUtils.drawCenteredText(this.graphics, 16, 16, this.width - 32, 18, this.title, TITLE_FONT, this.theme.getText());
        GraphicsUtils.drawCenteredText(this.graphics, this.xBoxStart, this.height - 16 - 12, this.boxWidth, 12, this.xAxisTitle, AXIS_FONT, this.theme.getText());
        GraphicsUtils.drawVerticalCenteredText(this.graphics, 16, 37, 12, this.height - 32 - 18 - 12 - 3 - 18, this.yAxisTitle, AXIS_FONT, this.theme.getText());
        this.graphics.setColor(this.theme.getGraphOutlineColor());
        this.graphics.drawRect(this.xBoxStart, this.yBoxStart, this.boxWidth, this.boxHeight);
        this.graphics.drawLine(this.xBoxStart, this.yBoxStart + this.boxHeight + 3, this.xBoxStart + this.boxWidth, this.yBoxStart + this.boxHeight + 3);
        for (double x : this.xAxisScale.getTicks()) {
            int dx = (int)((double)this.boxWidth * this.xAxisScale.getScaledValue(x));
            this.graphics.setColor(this.theme.getGraphOutlineColor());
            this.graphics.drawLine(this.xBoxStart + dx, this.yBoxStart + this.boxHeight + 3, this.xBoxStart + dx, this.yBoxStart + this.boxHeight + 6);
            GraphicsUtils.drawCenteredText(this.graphics, this.xBoxStart + dx - 20, this.yBoxStart + this.boxHeight + 6, 40, 10, this.xAxisScale.getValueString(x), TICK_FONT, this.theme.getText());
        }
        this.graphics.setColor(this.theme.getGraphOutlineColor());
        this.graphics.drawLine(this.xBoxStart - 3, this.yBoxStart, this.xBoxStart - 3, this.yBoxStart + this.boxHeight);
        for (double y : this.yAxisScale.getTicks()) {
            int dy = (int)((double)this.boxHeight * (1.0 - this.yAxisScale.getScaledValue(y)));
            this.graphics.setColor(this.theme.getGraphOutlineColor());
            this.graphics.drawLine(this.xBoxStart - 6, this.yBoxStart + dy, this.xBoxStart - 3, this.yBoxStart + dy);
            GraphicsUtils.drawVerticalCenteredText(this.graphics, this.xBoxStart - 9 - 10, this.yBoxStart + dy - 20, 10, 40, this.yAxisScale.getValueString(y), TICK_FONT, this.theme.getText());
        }
    }

    @Generated
    public BufferedImage getImage() {
        return this.image;
    }
}

