/*
 * Decompiled with CFR 0.152.
 */
package dev.aisandbox.server.engine;

import dev.aisandbox.server.engine.Agent;
import dev.aisandbox.server.engine.Simulation;
import dev.aisandbox.server.engine.exception.SimulationException;
import dev.aisandbox.server.engine.output.OutputRenderer;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimulationRunner
extends Thread {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SimulationRunner.class);
    private final Simulation simulation;
    private final OutputRenderer outputRenderer;
    private final List<Agent> agents;
    private final long maxStepCount;
    private boolean running = true;

    public void stopSimulation() {
        this.running = false;
        this.interrupt();
    }

    @Override
    public void run() {
        log.info("Writing output to {}", (Object)this.outputRenderer.getName());
        log.info("Starting simulation...");
        if (this.maxStepCount > -1L) {
            log.info("Max step count {}", (Object)this.maxStepCount);
        }
        long stepCount = 0L;
        while (stepCount != this.maxStepCount && this.running) {
            ++stepCount;
            try {
                this.simulation.step(this.outputRenderer);
            }
            catch (SimulationException e) {
                log.error(e.getMessage());
                this.running = false;
                this.outputRenderer.write(e.getMessage() + " stopping simulation.");
            }
        }
        if (stepCount == this.maxStepCount) {
            this.outputRenderer.write("Max step count reached, stopping...");
        }
        log.info("Simulation ended, cleaning up resources");
        this.simulation.close();
        this.agents.forEach(Agent::close);
    }

    @Generated
    public SimulationRunner(Simulation simulation, OutputRenderer outputRenderer, List<Agent> agents, long maxStepCount) {
        this.simulation = simulation;
        this.outputRenderer = outputRenderer;
        this.agents = agents;
        this.maxStepCount = maxStepCount;
    }
}

