/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.descriptive;

import org.apache.commons.statistics.descriptive.DoubleStatistic;
import org.apache.commons.statistics.descriptive.StatisticAccumulator;
import org.apache.commons.statistics.descriptive.SumOfSquaredDeviations;

public final class Variance
implements DoubleStatistic,
StatisticAccumulator<Variance> {
    private final SumOfSquaredDeviations ss;
    private boolean biased;

    private Variance() {
        this(new SumOfSquaredDeviations());
    }

    Variance(SumOfSquaredDeviations ss) {
        this.ss = ss;
    }

    public static Variance create() {
        return new Variance();
    }

    public static Variance of(double ... values) {
        return new Variance(SumOfSquaredDeviations.of(values));
    }

    @Override
    public void accept(double value) {
        this.ss.accept(value);
    }

    @Override
    public double getAsDouble() {
        double m2 = this.ss.getSumOfSquaredDeviations();
        if (!Double.isFinite(m2)) {
            return Double.NaN;
        }
        long n = this.ss.n;
        if (n == 1L) {
            return 0.0;
        }
        return this.biased ? m2 / (double)n : m2 / (double)(n - 1L);
    }

    @Override
    public Variance combine(Variance other) {
        this.ss.combine(other.ss);
        return this;
    }

    public Variance setBiased(boolean v) {
        this.biased = v;
        return this;
    }
}

