/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.descriptive;

import java.math.BigInteger;
import org.apache.commons.statistics.descriptive.Int128;
import org.apache.commons.statistics.descriptive.IntMath;
import org.apache.commons.statistics.descriptive.IntMean;
import org.apache.commons.statistics.descriptive.IntStatistic;
import org.apache.commons.statistics.descriptive.StatisticAccumulator;
import org.apache.commons.statistics.descriptive.UInt128;
import org.apache.commons.statistics.descriptive.UInt96;

public final class IntVariance
implements IntStatistic,
StatisticAccumulator<IntVariance> {
    static final int SMALL_SAMPLE = 10;
    private final UInt128 sumSq;
    private final Int128 sum;
    private long n;
    private boolean biased;

    private IntVariance() {
        this(UInt128.create(), Int128.create(), 0);
    }

    private IntVariance(UInt128 sumSq, Int128 sum, int n) {
        this.sumSq = sumSq;
        this.sum = sum;
        this.n = n;
    }

    public static IntVariance create() {
        return new IntVariance();
    }

    public static IntVariance of(int ... values) {
        if (values.length < 10) {
            IntVariance stat = new IntVariance();
            for (int x : values) {
                stat.accept(x);
            }
            return stat;
        }
        long s = 0L;
        UInt96 ss = UInt96.create();
        int end = values.length & 0xFFFFFFFE;
        for (int i = 0; i < end; i += 2) {
            long x = values[i];
            long y = values[i + 1];
            s += x + y;
            ss.addPositive(x * x + y * y);
        }
        if (end < values.length) {
            long x = values[end];
            s += x;
            ss.addPositive(x * x);
        }
        return new IntVariance(UInt128.of(ss), Int128.of(s), values.length);
    }

    @Override
    public void accept(int value) {
        this.sumSq.addPositive((long)value * (long)value);
        this.sum.add(value);
        ++this.n;
    }

    @Override
    public double getAsDouble() {
        return IntVariance.computeVarianceOrStd(this.sumSq, this.sum, this.n, this.biased, false);
    }

    static double computeVarianceOrStd(UInt128 sumSq, Int128 sum, long n, boolean biased, boolean std) {
        if (n == 0L) {
            return Double.NaN;
        }
        if (n == 1L) {
            return 0.0;
        }
        double diff = IntVariance.computeSSDevN(sumSq, sum, n);
        long n0 = biased ? n : n - 1L;
        double v = diff / IntMath.unsignedMultiplyToDouble(n, n0);
        if (std) {
            return Math.sqrt(v);
        }
        return v;
    }

    private static double computeSSDevN(UInt128 sumSq, Int128 sum, long n) {
        if (n >>> 32 == 0L) {
            return sumSq.unsignedMultiply((int)n).subtract(sum.squareLow()).toDouble();
        }
        return sumSq.toBigInteger().multiply(BigInteger.valueOf(n)).subtract(IntVariance.square(sum.toBigInteger())).doubleValue();
    }

    double computeSumOfSquaredDeviations() {
        return IntVariance.computeSSDevN(this.sumSq, this.sum, this.n) / (double)this.n;
    }

    double computeMean() {
        return IntMean.computeMean(this.sum, this.n);
    }

    private static BigInteger square(BigInteger x) {
        return x.multiply(x);
    }

    @Override
    public IntVariance combine(IntVariance other) {
        this.sumSq.add(other.sumSq);
        this.sum.add(other.sum);
        this.n += other.n;
        return this;
    }

    public IntVariance setBiased(boolean v) {
        this.biased = v;
        return this;
    }
}

