/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.descriptive;

import java.util.function.DoubleConsumer;
import org.apache.commons.numbers.core.Sum;

class FirstMoment
implements DoubleConsumer {
    private static final double DOWNSCALE = 0.5;
    private static final double RESCALE = 2.0;
    protected long n;
    protected double dev;
    protected double nDev;
    private double m1;
    private double nonFiniteValue;

    FirstMoment() {
    }

    FirstMoment(FirstMoment source) {
        this.m1 = source.m1;
        this.n = source.n;
        this.nonFiniteValue = source.nonFiniteValue;
    }

    FirstMoment(double m1, long n) {
        this.m1 = m1 * 0.5;
        this.n = n;
    }

    static FirstMoment of(double ... values) {
        if (values.length == 0) {
            return new FirstMoment();
        }
        return FirstMoment.create(Sum.of((double[])values), values);
    }

    static FirstMoment create(Sum sum, double[] values) {
        if (values.length == 0) {
            return new FirstMoment();
        }
        double s = sum.getAsDouble();
        if (Double.isFinite(s)) {
            return new FirstMoment(s / (double)values.length, values.length);
        }
        FirstMoment m1 = FirstMoment.create(values);
        double xbar = m1.getFirstMoment();
        if (!Double.isFinite(xbar)) {
            return m1;
        }
        double correction = 0.0;
        for (double x : values) {
            correction += x - xbar;
        }
        if (Double.isFinite(correction)) {
            m1.m1 += 0.5 * correction / (double)values.length;
        }
        return m1;
    }

    private static FirstMoment create(double[] values) {
        double m1 = 0.0;
        int n = 0;
        for (double x : values) {
            m1 += (x * 0.5 - m1) / (double)(++n);
        }
        FirstMoment m = new FirstMoment();
        m.n = n;
        m.m1 = m1;
        if (!Double.isFinite(m1 * 2.0)) {
            m.nonFiniteValue = FirstMoment.computeNonFiniteValue(values);
        }
        return m;
    }

    private static double computeNonFiniteValue(double[] values) {
        double sum = 0.0;
        for (double x : values) {
            sum += x * Double.MIN_NORMAL;
        }
        return sum;
    }

    @Override
    public void accept(double value) {
        this.nonFiniteValue += value * Double.MIN_NORMAL;
        this.dev = value * 0.5 - this.m1;
        this.nDev = this.dev / (double)(++this.n);
        this.m1 += this.nDev;
    }

    double getFirstMoment() {
        double m = this.m1 * 2.0;
        if (Double.isFinite(m)) {
            return this.n == 0L ? Double.NaN : m;
        }
        return this.nonFiniteValue;
    }

    FirstMoment combine(FirstMoment other) {
        this.nonFiniteValue += other.nonFiniteValue;
        double mu1 = this.m1;
        double mu2 = other.m1;
        long n1 = this.n;
        long n2 = other.n;
        this.n = n1 + n2;
        this.m1 = n1 == n2 ? (mu1 + mu2) * 0.5 : FirstMoment.combine(mu1, mu2, n1, n2);
        return this;
    }

    private static double combine(double m1, double m2, long n1, long n2) {
        return n2 < n1 ? m1 + (m2 - m1) * ((double)n2 / (double)(n1 + n2)) : m2 + (m1 - m2) * ((double)n1 / (double)(n1 + n2));
    }

    double getFirstMomentDifference(FirstMoment other) {
        return (this.m1 - other.m1) * 2.0;
    }

    double getFirstMomentHalfDifference(FirstMoment other) {
        return this.m1 - other.m1;
    }
}

