/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.descriptive;

import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.DoubleConsumer;
import java.util.function.Function;
import org.apache.commons.statistics.descriptive.DoubleStatistic;
import org.apache.commons.statistics.descriptive.FirstMoment;
import org.apache.commons.statistics.descriptive.GeometricMean;
import org.apache.commons.statistics.descriptive.Kurtosis;
import org.apache.commons.statistics.descriptive.Max;
import org.apache.commons.statistics.descriptive.Min;
import org.apache.commons.statistics.descriptive.Product;
import org.apache.commons.statistics.descriptive.Skewness;
import org.apache.commons.statistics.descriptive.StandardDeviation;
import org.apache.commons.statistics.descriptive.Statistic;
import org.apache.commons.statistics.descriptive.StatisticResult;
import org.apache.commons.statistics.descriptive.Statistics;
import org.apache.commons.statistics.descriptive.StatisticsConfiguration;
import org.apache.commons.statistics.descriptive.Sum;
import org.apache.commons.statistics.descriptive.SumOfCubedDeviations;
import org.apache.commons.statistics.descriptive.SumOfFourthDeviations;
import org.apache.commons.statistics.descriptive.SumOfLogs;
import org.apache.commons.statistics.descriptive.SumOfSquaredDeviations;
import org.apache.commons.statistics.descriptive.SumOfSquares;
import org.apache.commons.statistics.descriptive.Variance;

public final class DoubleStatistics
implements DoubleConsumer {
    private static final String NO_CONFIGURED_STATISTICS = "No configured statistics";
    private static final String UNSUPPORTED_STATISTIC = "Unsupported statistic: ";
    private long count;
    private final DoubleConsumer consumer;
    private final Min min;
    private final Max max;
    private final FirstMoment moment;
    private final Sum sum;
    private final Product product;
    private final SumOfSquares sumOfSquares;
    private final SumOfLogs sumOfLogs;
    private StatisticsConfiguration config;

    DoubleStatistics(long count, Min min, Max max, FirstMoment moment, Sum sum, Product product, SumOfSquares sumOfSquares, SumOfLogs sumOfLogs, StatisticsConfiguration config) {
        this.count = count;
        this.min = min;
        this.max = max;
        this.moment = moment;
        this.sum = sum;
        this.product = product;
        this.sumOfSquares = sumOfSquares;
        this.sumOfLogs = sumOfLogs;
        this.config = config;
        this.consumer = Statistics.compose(min, max, moment, sum, product, sumOfSquares, sumOfLogs);
    }

    public static DoubleStatistics of(Statistic ... statistics) {
        return DoubleStatistics.builder(statistics).build();
    }

    public static DoubleStatistics of(Set<Statistic> statistics, double ... values) {
        if (statistics.isEmpty()) {
            throw new IllegalArgumentException(NO_CONFIGURED_STATISTICS);
        }
        Builder b = new Builder();
        statistics.forEach(b::add);
        return b.build(values);
    }

    public static Builder builder(Statistic ... statistics) {
        if (statistics.length == 0) {
            throw new IllegalArgumentException(NO_CONFIGURED_STATISTICS);
        }
        Builder b = new Builder();
        for (Statistic s : statistics) {
            b.add(s);
        }
        return b;
    }

    @Override
    public void accept(double value) {
        ++this.count;
        this.consumer.accept(value);
    }

    public long getCount() {
        return this.count;
    }

    public boolean isSupported(Statistic statistic) {
        switch (statistic) {
            case GEOMETRIC_MEAN: 
            case SUM_OF_LOGS: {
                return this.sumOfLogs != null;
            }
            case KURTOSIS: {
                return this.moment instanceof SumOfFourthDeviations;
            }
            case MAX: {
                return this.max != null;
            }
            case MEAN: {
                return this.moment != null;
            }
            case MIN: {
                return this.min != null;
            }
            case PRODUCT: {
                return this.product != null;
            }
            case SKEWNESS: {
                return this.moment instanceof SumOfCubedDeviations;
            }
            case STANDARD_DEVIATION: 
            case VARIANCE: {
                return this.moment instanceof SumOfSquaredDeviations;
            }
            case SUM: {
                return this.sum != null;
            }
            case SUM_OF_SQUARES: {
                return this.sumOfSquares != null;
            }
        }
        return false;
    }

    public double getAsDouble(Statistic statistic) {
        return this.getResult(statistic).getAsDouble();
    }

    public StatisticResult getResult(Statistic statistic) {
        StatisticResult stat = null;
        switch (statistic) {
            case GEOMETRIC_MEAN: {
                stat = this.getGeometricMean();
                break;
            }
            case KURTOSIS: {
                stat = this.getKurtosis();
                break;
            }
            case MAX: {
                stat = this.max;
                break;
            }
            case MEAN: {
                stat = this.getMean();
                break;
            }
            case MIN: {
                stat = this.min;
                break;
            }
            case PRODUCT: {
                stat = this.product;
                break;
            }
            case SKEWNESS: {
                stat = this.getSkewness();
                break;
            }
            case STANDARD_DEVIATION: {
                stat = this.getStandardDeviation();
                break;
            }
            case SUM: {
                stat = this.sum;
                break;
            }
            case SUM_OF_LOGS: {
                stat = this.sumOfLogs;
                break;
            }
            case SUM_OF_SQUARES: {
                stat = this.sumOfSquares;
                break;
            }
            case VARIANCE: {
                stat = this.getVariance();
                break;
            }
        }
        if (stat != null) {
            return stat instanceof DoubleStatistic ? ((DoubleStatistic)stat)::getAsDouble : stat;
        }
        throw new IllegalArgumentException(UNSUPPORTED_STATISTIC + (Object)((Object)statistic));
    }

    private StatisticResult getGeometricMean() {
        if (this.sumOfLogs != null) {
            return () -> GeometricMean.computeGeometricMean(this.count, this.sumOfLogs);
        }
        return null;
    }

    private StatisticResult getKurtosis() {
        if (this.moment instanceof SumOfFourthDeviations) {
            return new Kurtosis((SumOfFourthDeviations)this.moment).setBiased(this.config.isBiased())::getAsDouble;
        }
        return null;
    }

    private StatisticResult getMean() {
        if (this.moment != null) {
            return this.moment::getFirstMoment;
        }
        return null;
    }

    private StatisticResult getSkewness() {
        if (this.moment instanceof SumOfCubedDeviations) {
            return new Skewness((SumOfCubedDeviations)this.moment).setBiased(this.config.isBiased())::getAsDouble;
        }
        return null;
    }

    private StatisticResult getStandardDeviation() {
        if (this.moment instanceof SumOfSquaredDeviations) {
            return new StandardDeviation((SumOfSquaredDeviations)this.moment).setBiased(this.config.isBiased())::getAsDouble;
        }
        return null;
    }

    private StatisticResult getVariance() {
        if (this.moment instanceof SumOfSquaredDeviations) {
            return new Variance((SumOfSquaredDeviations)this.moment).setBiased(this.config.isBiased())::getAsDouble;
        }
        return null;
    }

    public DoubleStatistics combine(DoubleStatistics other) {
        Statistics.checkCombineCompatible(this.min, other.min);
        Statistics.checkCombineCompatible(this.max, other.max);
        Statistics.checkCombineCompatible(this.sum, other.sum);
        Statistics.checkCombineCompatible(this.product, other.product);
        Statistics.checkCombineCompatible(this.sumOfSquares, other.sumOfSquares);
        Statistics.checkCombineCompatible(this.sumOfLogs, other.sumOfLogs);
        Statistics.checkCombineAssignable(this.moment, other.moment);
        this.count += other.count;
        Statistics.combine(this.min, other.min);
        Statistics.combine(this.max, other.max);
        Statistics.combine(this.sum, other.sum);
        Statistics.combine(this.product, other.product);
        Statistics.combine(this.sumOfSquares, other.sumOfSquares);
        Statistics.combine(this.sumOfLogs, other.sumOfLogs);
        Statistics.combineMoment(this.moment, other.moment);
        return this;
    }

    public DoubleStatistics setConfiguration(StatisticsConfiguration v) {
        this.config = Objects.requireNonNull(v);
        return this;
    }

    public static final class Builder {
        private static final double[] NO_VALUES = new double[0];
        private Function<double[], Min> min;
        private Function<double[], Max> max;
        private BiFunction<org.apache.commons.numbers.core.Sum, double[], FirstMoment> moment;
        private Function<org.apache.commons.numbers.core.Sum, Sum> sum;
        private Function<double[], Product> product;
        private Function<double[], SumOfSquares> sumOfSquares;
        private Function<double[], SumOfLogs> sumOfLogs;
        private int momentOrder;
        private StatisticsConfiguration config = StatisticsConfiguration.withDefaults();

        Builder() {
        }

        Builder add(Statistic statistic) {
            switch (statistic) {
                case GEOMETRIC_MEAN: 
                case SUM_OF_LOGS: {
                    this.sumOfLogs = SumOfLogs::of;
                    break;
                }
                case KURTOSIS: {
                    this.createMoment(4);
                    break;
                }
                case MAX: {
                    this.max = Max::of;
                    break;
                }
                case MEAN: {
                    this.createMoment(1);
                    break;
                }
                case MIN: {
                    this.min = Min::of;
                    break;
                }
                case PRODUCT: {
                    this.product = Product::of;
                    break;
                }
                case SKEWNESS: {
                    this.createMoment(3);
                    break;
                }
                case STANDARD_DEVIATION: 
                case VARIANCE: {
                    this.createMoment(2);
                    break;
                }
                case SUM: {
                    this.sum = Sum::new;
                    break;
                }
                case SUM_OF_SQUARES: {
                    this.sumOfSquares = SumOfSquares::of;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(DoubleStatistics.UNSUPPORTED_STATISTIC + (Object)((Object)statistic));
                }
            }
            return this;
        }

        private void createMoment(int order) {
            if (order > this.momentOrder) {
                this.momentOrder = order;
                this.moment = order == 4 ? SumOfFourthDeviations::create : (order == 3 ? SumOfCubedDeviations::create : (order == 2 ? SumOfSquaredDeviations::create : FirstMoment::create));
            }
        }

        public Builder setConfiguration(StatisticsConfiguration v) {
            this.config = Objects.requireNonNull(v);
            return this;
        }

        public DoubleStatistics build() {
            return this.build(NO_VALUES);
        }

        public DoubleStatistics build(double ... values) {
            Objects.requireNonNull(values, "values");
            FirstMoment m = null;
            Sum sumStat = null;
            if (this.moment != null || this.sum != null) {
                org.apache.commons.numbers.core.Sum s = org.apache.commons.numbers.core.Sum.of((double[])values);
                m = Builder.create(this.moment, s, values);
                sumStat = Builder.create(this.sum, s);
            }
            return new DoubleStatistics(values.length, Builder.create(this.min, values), Builder.create(this.max, values), m, sumStat, Builder.create(this.product, values), Builder.create(this.sumOfSquares, values), Builder.create(this.sumOfLogs, values), this.config);
        }

        private static <S, T> T create(Function<S, T> constructor, S values) {
            if (constructor != null) {
                return constructor.apply(values);
            }
            return null;
        }

        private static <R, S, T> T create(BiFunction<R, S, T> constructor, R r, S s) {
            if (constructor != null) {
                return constructor.apply(r, s);
            }
            return null;
        }
    }
}

